<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Article extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'news';
    private $control = 'admin/article';
    private $folder_view = 'super/article';
    private $pk = 'id';

    public function index() {
        $data = array(
            'data_page' => $this->model_app->getAllData($this->table)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function add_article() {
        $key['id'] = '';
        $data = array(
            'data_page' => $this->model_app->getSelectedData($this->table, $key),
        );
        renderSuper("$this->folder_view/add", $data);
    }

    function edit_data() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'data_page' => $this->model_app->getSelectedData($this->table, $key)
        );
        renderSuper("$this->folder_view/add", $data);
    }

    function delete_data() {
        $key['id'] = $this->uri->segment(4);
        $cek = $this->model_app->getSelectedData($this->table, $key);
        if ($cek->num_rows() > 0) {

            $this->model_app->deleteData($this->table, $key);
            redirect($this->control);
        } else {
            echo "No input specified file";
        }
    }

    function simpanData() {
        $id = $this->input->post('id_page');
        $key['id'] = $id;
        $m_key = $this->input->post('meta_keyword');
        $m_desc = $this->input->post('meta_description');
        $title = $this->input->post('title');
        $content = $this->input->post('editor');

        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/article');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '100%',
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'meta_keyword' => $m_key,
                        'meta_description' => $m_desc,
                        'title' => $title,
                        'content' => $content,
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext'],
                        'datepost' => date("Y-m-d")
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->image_file;
                            $pathFile = realpath(APPPATH . '../assets/article/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'meta_keyword' => $m_key,
                    'meta_description' => $m_desc,
                    'title' => $title,
                    'content' => $content,
                    'datepost' => date("Y-m-d")
                );
                if ($cek->num_rows() > 0) {
                    $this->model_app->updateData($this->table, $data, $key);
                } else {
                    $this->model_app->insertData($this->table, $data);
                }
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

    function updateData() {
        $key['id'] = $this->input->post('id_page');
        $title = $this->input->post('title');
        $content = $this->input->post('content');
        $data = array(
            'title' => $title,
            'content' => $content
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

}

/* End of file article.php */
/* Location: ./application/controllers/article.php */