<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gallery extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->load->helper('html');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'gallery';
    private $control = 'admin/gallery';
    private $folder_view = 'super/gallery/gallery';
    private $pk = 'id';

    public function index() {
        $data = array(
            'gallery' => $this->db->get('gallery')
        );
        renderSuper($this->folder_view, $data);
    }

    public function simpanUpload() {
        $path = realpath(APPPATH . '../assets/gallery');
        if (isset($_FILES['image'])) {
            $data = $_FILES['image'];
            $total = count($data['name']);
            $data2 = array();
            for ($i = 0; $i < $total; $i++) {
                $data2[] = array(
                    'name' => $data['name'][$i],
                    'type' => $data['type'][$i],
                    'tmp_name' => $data['tmp_name'][$i],
                    'error' => $data['error'][$i],
                    'size' => $data['size'][$i],
                );
            }

            $no = 0;
            foreach ($data2 as $row) {
                $config['upload_path'] = './assets/gallery';
                $config['allowed_types'] = 'gif|jpg|png|bmp';
                $this->load->library('multi_upload', $config);
                if ($this->multi_upload->do_upload($data2[$no])) {
                    $image_data = $this->multi_upload->data();
                    $datasimpan = array(
                        'picture' => $image_data['file_name']
                    );
                    $this->model_app->insertData($this->table, $datasimpan);
                    $this->image_lib->initialize(array(
                        'image_library' => 'gd2',
                        'source_image' => $path . '/' . $image_data['file_name'],
                        'maintain_ratio' => false,
                        //  'create_thumb' => true,
                        'quality' => '90%',
                        'width' => 480,
                        'height' => 320,
                        'overwrite' => TRUE
                    ));
                    if ($this->image_lib->resize()) {
                        
                        $data = $this->model_app->getAllData($this->table);
                    }
                }
                $no++;
            }

            $this->session->set_flashdata('message_green_password', 'Data Telah Berhasil Disimpan');
            redirect("$this->control/index");
        }
    }

    function hapus() {
        $key['id_picture'] = $this->uri->segment(4);
        $gambar = $this->uri->segment(5);
        $this->model_app->deleteData($this->table, $key);
        $pathFile = realpath(APPPATH . '../assets/gallery/' . $gambar);
        unlink($pathFile);
        redirect($this->control);
    }

}

/* End of file gallery.php */
/* Location: ./application/controllers/gallery.php */