<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Halaman extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'page';
    private $control = 'admin/halaman';
    private $folder_view = 'super/halaman';
    private $pk = 'id_page';

    public function index() {
        $data = array(
            'data_page' => $this->model_app->getAllData($this->table)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function edit_data() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'id_page' => 'id',
            'data_page' => $this->model_app->getSelectedData($this->table, $key)
        );
        renderSuper("$this->folder_view/edit", $data);
    }

    function form_insert() {
        $key['id'] = '';
        $data = array(
            'id_page' => '',
            'data_page' => $this->model_app->getSelectedData($this->table, $key)
        );
        renderSuper("$this->folder_view/edit", $data);
    }

    function insertData() {
        $key_page = $this->input->post('key_page');
        $title = $this->input->post('title');
        $content = $this->input->post('editor');
        $data = array(
            'key_page' => $key_page,
            'title' => $title,
            'content' => $content
        );
        $this->model_app->insertData($this->table, $data);
        redirect($this->control);
    }

    function updateData() {
        $key['id'] = $this->input->post('id_page');
        $key_page = $this->input->post('key_page');
        $title = $this->input->post('title');
        $content = $this->input->post('editor');

        $data = array(
            'key_page' => $key_page,
            'title' => $title,
            'content' => $content
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function simpanData() {
        $id = $this->input->post('id_page');
        $key['id'] = $id;
        $key_page = $this->input->post('key_page');
        $title = $this->input->post('title');
        $content = $this->input->post('editor');
        $desc = $this->input->post('desc');
        $m_key = $this->input->post('m_key');

        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/page');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '100%',
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'key_page' => $key_page,
                        'title' => $title,
                        'content' => $content,
                        'description' => $desc,
                        'keyword_page' => $m_key,
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext'],
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->image_file;
                            $pathFile = realpath(APPPATH . '../assets/page/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'key_page' => $key_page,
                    'title' => $title,
                    'content' => $content,
                    'description' => $desc,
                    'keyword_page' => $m_key,
                );
                if ($cek->num_rows() > 0) {
                    $this->model_app->updateData($this->table, $data, $key);
                } else {
                    $this->model_app->insertData($this->table, $data);
                }
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

    function deleteData() {
        $key['id'] = $this->uri->segment(4);
        $this->model_app->deleteData($this->table, $key);
        redirect($this->control);
    }

}

/* End of file halaman.php */
/* Location: ./application/controllers/halaman.php */