<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Loginpage extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('fungsi_login');
    }

    function index() {
        $this->load->view('super/login');
    }

    function do_login() {
        $userinput = $this->input->post('username');
        if (!empty($userinput)) {
            $result = $this->fungsi_login->login_admin();
            if ($result == TRUE) {
                $data = array(
                    'username' => $this->input->post('username'),
                    'isLoggedIn' => true
                );
                session_start();
                $this->session->set_userdata($data);
                $_SESSION['ses_kcfinder'] = array();
                $_SESSION['ses_kcfinder']['disabled'] = false;
                $_SESSION['ses_kcfinder']['uploadURL'] = "../content_upload";
                redirect('admin/dashboard');
            } else {
                $this->session->set_flashdata('message_red_password', 'LOGIN GAGAL CEK LAGI USERNAME DAN PASSWORD ANDA !');
                redirect('admin/loginpage');
            }
        } else {
            $this->session->set_flashdata('message_red_password', 'LOGIN GAGAL USERNAMENYA BELUM DIISI !');
            redirect('admin/loginpage');
        }
    }

    function testForward(){
      redirect('admin/dashboard');
    }

    function lockuser() {
        $this->session->sess_destroy();
        $this->load->view('super/lockuser');
    }

    function unlock() {
        $userinput = $this->input->post('password');
        if (!empty($userinput)) {
            $result = $this->fungsi_login->unlock_admin();
            if ($result == TRUE) {
                $data = array(
                    'isLoggedIn' => true
                );
                session_start();
                $this->session->set_userdata($data);
                redirect('admin/dashboard');
            } else {
                $this->session->set_flashdata('message_red_password', 'LOGIN GAGAL CEK LAGI USERNAME DAN PASSWORD ANDA !');
                redirect('admin/loginpage/lockuser');
            }
        } else {
            $this->session->set_flashdata('message_red_password', 'LOGIN GAGAL USERNAMENYA BELUM DIISI !');
            redirect('admin/loginpage/lockuser');
        }
    }

    public function keluar() {
        $this->session->sess_destroy();
        $this->index();
    }

    function keepalive() {
        echo "I am Live";
    }

}

/* End of file loginpage.php */
/* Location: ./application/controllers/loginpage.php */
