<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menu extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'main_menu';
    private $control = 'admin/menu';
    private $folder_view = 'super/menu/main_menu';
    private $pk = 'id_menu';

    public function index() {
        $data = array(
            'data_mainMenu' => $this->model_app->getAllData($this->table)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function tambah_data() {
        $key['id_menu'] = '';
        $data = array(
            'id_menu' => '',
            'data_menu' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('product_category')->result(),
            'data_page' => $this->model_app->getAllData('page')->result(),
        );
        renderSuper("$this->folder_view/insert", $data);
    }

    function changeorder() {
        $data = array(
            'data_menu' => $this->model_app->getAllData($this->table)
        );
        renderSuper("$this->folder_view/changeorder", $data);
    }

    function simpanMainMenu() {
        $id = $this->input->post('id_menu');
        $key['id_menu'] = $id;

        $name = $this->input->post('menu_name');
        $active = $this->input->post('active');
        $order = $this->input->post('no_order');
        $key_page = $this->input->post('key_page');
        $cek = $this->model_app->getSelectedData($this->table, $key)->num_rows();
        if ($cek == 0) {
            $data = array(
                'id_menu' => $id,
                'menu_name' => $name,
                'active' => $active,
                'order' => $order,
                'key_page' => $key_page
            );
            $this->model_app->insertData($this->table, $data);
        } else {
            $data = array(
                'menu_name' => $name,
                'active' => $active,
                'order' => $order,
                'key_page' => $key_page
            );
            $this->model_app->updateData($this->table, $data, $key);
        }
        redirect($this->control);
    }

    function simpanData() {
        $id = $this->input->post('id_menu');
        $key['id_menu'] = $id;

        $name = $this->input->post('menu_name');
        $active = $this->input->post('active');
        $order = $this->input->post('no_order');
        $key_page = $this->input->post('key_page');

        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/menu');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '100%',
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'menu_name' => $name,
                        'active' => $active,
                        'order' => $order,
                        'key_page' => $key_page,
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext'],
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->image_file;
                            $pathFile = realpath(APPPATH . '../assets/menu/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'menu_name' => $name,
                    'active' => $active,
                    'order' => $order,
                    'key_page' => $key_page,
                );
                if ($cek->num_rows() > 0) {
                    $this->model_app->updateData($this->table, $data, $key);
                } else {
                    $this->model_app->insertData($this->table, $data);
                }
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

    function updateOrder() {
        $key['id_menu'] = $this->input->post('id_menu');
        $data['order'] = $this->input->post('order');
        $cek = $this->model_app->getSelectedData($this->table, $data)->num_rows();
        if ($cek > 0) {
            echo "Nomor Order sudah digunakan!";
        } else {
            $this->model_app->updateData($this->table, $data, $key);
            echo "Berhasil Mengganti Nomor Order";
        }
    }

    function deleteData() {
        $key['id_menu'] = $this->uri->segment(4);
        $this->model_app->deleteData($this->table, $key);
        redirect($this->control);
    }

    public function editData() {
        $key['id_menu'] = $this->uri->segment(4);
        $data = array(
            'data_menu' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('product_category')->result(),
            'data_page' => $this->model_app->getAllData('page')->result(),
        );
        renderSuper($this->folder_view . "/insert", $data);
    }

    function changeActive() {
        $key['id_menu'] = $this->uri->segment(4);
        $data = array(
            'active' => 'Yes'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeNonActive() {
        $key['id_menu'] = $this->uri->segment(4);
        $data = array(
            'active' => 'No'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

}

/* End of file menu.php */
/* Location: ./application/controllers/menu.php */