<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->load->helper('html');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'product';
    private $control = 'admin/product';
    private $folder_view = 'super/product/products';
    private $pk = 'id';

    public function index() {
        $query_prod = "SELECT * FROM $this->table order by product_name";
        $data = array(
            'kategori' => $this->model_app->getAllData('product_category'),
            'data_product' => $this->model_app->manualQuery($query_prod)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function tambah_data() {
        $key['id'] = '';
        $data = array(
            'data_product' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('kategori_utama')
        );
        renderSuper("$this->folder_view/insert", $data);
    }

    function edit_data() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'data_product' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('kategori_utama')
        );
        renderSuper("$this->folder_view/insert", $data);
    }

    function add_stock() {
        $key['product_id'] = '';
        $data = array(
            'data_qty' => $this->model_app->getSelectedData('qty_product', $key),
            'data_category' => $this->model_app->getAllData('kategori_utama')
        );
        renderSuper("super/products/add_stock", $data);
    }

    function edit_stock() {
        $key['product_id'] = $this->uri->segment(4);
        $data = array(
            'data_qty' => $this->model_app->getSelectedData('qty_product', $key),
            'data_category' => $this->model_app->getAllData('kategori_utama')
        );
        renderSuper("super/products/add_stock", $data);
    }

    function deleteData() {
        $key['id'] = $this->uri->segment(4);
        $this->model_app->deleteData($this->table, $key);
        redirect($this->control);
    }

    function simpanData() {
        $id = $this->input->post('id');
        $key['id'] = $id;
        $id_kat = $this->input->post('id_category');
        $nama = $this->input->post('product_name');
        $cost = $this->input->post('cost');
        $price = $this->input->post('price');
        $diskon = $this->input->post('discount');
        $desk = $this->input->post('description');
        $berat = $this->input->post('berat');

        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/product_image');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
//                    'quality' => '100%',
//                    'width' => 480,
//                    'height' => 480,
                    'overwrite' => TRUE
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'category_id' => $id_kat,
                        'product_name' => $nama,
                        'cost' => (int) str_replace('.', '', $cost),
                        'price' => (int) str_replace('.', '', $price),
                        'discount' => $diskon,
                        'description' => $desk,
                        'weight' => $berat,
                        'product_image' => $data_upload['raw_name'] . $data_upload['file_ext']
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->product_image;
                            $pathFile = realpath(APPPATH . '../assets/product_image/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'category_id' => $id_kat,
                    'product_name' => $nama,
                    'cost' => (int) str_replace('.', '', $cost),
                    'price' => (int) str_replace('.', '', $price),
                    'discount' => $diskon,
                    'weight' => $berat,
                    'description' => $desk
                );
                if ($cek->num_rows() > 0) {
                    $this->model_app->updateData($this->table, $data, $key);
                } else {
                    $this->model_app->insertData($this->table, $data);
                }
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }


    }

    function getProduct() {
        $key['category_id'] = $this->input->post('id_kat');
        $data = $this->model_app->getSelectedData($this->table, $key)->result();
        echo "<option>-Choose One-</option>";
        foreach ($data as $d) {
            echo "<option value=$d->id>$d->product_name</option>";
        }
    }

    function getQTY() {
        $key['product_id'] = $this->input->post('produk');
        $data = $this->model_app->getSelectedData('qty_product', $key);
        if ($data->num_rows() == 0) {
            echo "0";
        } else {
            foreach ($data->result() as $d) {
                echo $d->qty;
            }
        }
    }

    function getImage() {
        $key['product_id'] = $this->input->post('produk');
        $data = $this->model_app->getSelectedData('product_image', $key);
        if ($data->num_rows() == 0) {
            echo "belum ada foto lain selain foto utama";
        } else {
            foreach ($data->result() as $d) {
                echo img(array(
                    'src' => base_url() . "assets/product_image/" . $d->product_image,
                    'width' => 180,
                    'height' => 180,
                    'style' => 'margin:10px; padding:10px; background:#bbb'
                ));
            }
        }
    }

    function simpanStock() {
        //$id = $this->input->post('id');
        //$key['id'] = $id;
        $produk = $this->input->post('produk');
        $key2['product_id'] = $produk;
        $qty = $this->input->post('qty');
        $tgl = date("Y-m-d");
        //$cek = $this->model_app->getSelectedData('qty_product', $key)->num_rows();
        $cek2 = $this->model_app->getSelectedData('qty_product', $key2)->num_rows();
        if ($cek2 == 0) {
            $data = array(
                'insert_date' => $tgl,
                'product_id' => $produk,
                'qty' => $qty
            );
            $this->model_app->insertData('qty_product', $data);
        } else if ($cek2 == 1) {
            $data = array(
                'insert_date' => $tgl,
                'qty' => $qty
            );
            $this->model_app->updateData('qty_product', $data, $key2);
        }
        redirect($this->control);
    }

    function setDiscount() {
        $key['id'] = $this->input->post('id_product');
        $data['discount'] = $this->input->post('diskon');
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function setNewProduct() {
        $key['id'] = $this->input->post('id_product');
        $data['new'] = date("Y-m-d", strtotime($this->input->post('new')));
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function setStockProduct() {
        $key['id'] = $this->input->post('id_product');
        $data['stock'] = $this->input->post('stok');
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function set_kategori() {
        $produk_id = $this->input->post('id_product');
        $tag = $this->input->post('tagline');

        foreach ($tag as $tg) {
            $data = array(
                'product_id' => $produk_id,
                'kategori_id' => $tg
            );
            $this->model_app->insertData('tag_product', $data);
        }
        redirect($this->control);
    }

    function nonAktifNew() {
        $key['id'] = $this->uri->segment(4);
        $data['new'] = date("Y-m-d");
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeActive() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'status' => 'Yes'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeNonActive() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'status' => 'No'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeFeatured() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'featured' => 'Yes'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeNonFeatured() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'featured' => 'No'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function new_product() {
        $query_prod = "SELECT * FROM $this->table where new != null or new = '' order by product_name";
        $data = array(
            'kategori' => $this->model_app->getAllData('product_category'),
            'data_product' => $this->model_app->manualQuery($query_prod)
        );
        renderSuper("$this->folder_view/data", $data);
    }

}

/* End of file product.php */
/* Location: ./application/controllers/product.php */