<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product_category extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Product_category_model');
        $this->load->model('model_app');
        $this->load->library('form_validation');
    }

    private $table = 'product_category';
    private $control = 'admin/product_category';
    private $view = 'super/product/kategori';

    public function index() {
        $product_category = $this->Product_category_model->getAllData_order_by('name','asc');

        $data = array(
            'product_category_data' => $product_category
        );

        renderSuper("$this->view/product_category_list", $data);
    }

    public function read($id) {
        $row = $this->Product_category_model->get_by_id($id);
        if ($row) {
            $data = array(
                'id' => $row->id,
                'name' => $row->name,
            );
            renderSuper("$this->view/product_category_read", $data);
        } else {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('admin/product_category'));
        }
    }

    public function create() {
        $data = array(
            'button' => 'Create',
            'action' => site_url('admin/product_category/create_action'),
            'id' => set_value('id'),
            'name' => set_value('name'),
        );
        renderSuper("$this->view/product_category_form", $data);
    }

    public function create_action() {
        $this->_rules();

        if ($this->form_validation->run() == FALSE) {
            $this->create();
        } else {
            $data = array(
                'name' => $this->input->post('name', TRUE),
            );

            $this->Product_category_model->insert($data);
            $this->session->set_flashdata('message', 'Create Record Success');
            redirect(site_url('admin/product_category'));
        }
    }

    public function update($id) {
        $row = $this->Product_category_model->get_by_id($id);

        if ($row) {
            $data = array(
                'button' => 'Update',
                'action' => site_url('admin/product_category/update_action'),
                'id' => set_value('id', $row->id),
                'name' => set_value('name', $row->name),
            );
            renderSuper("$this->view/product_category_form", $data);
        } else {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('admin/product_category'));
        }
    }

    public function update_action() {
        $this->_rules();

        if ($this->form_validation->run() == FALSE) {
            $this->update($this->input->post('id', TRUE));
        } else {
            $data = array(
                'name' => $this->input->post('name', TRUE),
            );

            $this->Product_category_model->update($this->input->post('id', TRUE), $data);
            $this->session->set_flashdata('message', 'Update Record Success');
            redirect(site_url('admin/product_category'));
        }
    }

    public function delete($id) {
        $row = $this->Product_category_model->get_by_id($id);

        if ($row) {
            $this->Product_category_model->delete($id);
            $this->session->set_flashdata('message', 'Delete Record Success');
            redirect(site_url('admin/product_category'));
        } else {
            $this->session->set_flashdata('message', 'Record Not Found');
            redirect(site_url('admin/product_category'));
        }
    }

    public function _rules() {
        $this->form_validation->set_rules('name', 'name', 'trim|required');

        $this->form_validation->set_rules('id', 'id', 'trim');
        $this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
    }

}

/* End of file product_category.php */
/* Location: ./application/controllers/product_category.php */