<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Product_image extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->load->helper('html');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'product_image';
    private $control = 'admin/product_image';
    private $folder_view = 'super/product/product_image';
    private $pk = 'id';

    public function index() {
        $data = array(
            'product' => $this->model_app->getAllData('product')->result()
        );
        renderSuper($this->folder_view . "/data", $data);
    }

    public function simpanUpload() {
        $id = $this->input->post('product');
        $path = realpath(APPPATH . '../assets/product_image');
        if (isset($_FILES['image'])) {
            $data = $_FILES['image'];
            $total = count($data['name']);
            $data2 = array();
            for ($i = 0; $i < $total; $i++) {
                $data2[] = array(
                    'name' => $data['name'][$i],
                    'type' => $data['type'][$i],
                    'tmp_name' => $data['tmp_name'][$i],
                    'error' => $data['error'][$i],
                    'size' => $data['size'][$i],
                );
            }

            $no = 0;
            foreach ($data2 as $row) {
                $config['upload_path'] = './assets/product_image';
                $config['allowed_types'] = 'gif|jpg|png|bmp';
                $this->load->library('multi_upload', $config);
                if ($this->multi_upload->do_upload($data2[$no])) {
                    $image_data = $this->multi_upload->data();
                    $datasimpan = array(
                        'product_id' => $id,
                        'product_image' => $image_data['file_name']
                    );
                    $this->model_app->insertData($this->table, $datasimpan);
                    $this->image_lib->initialize(array(
                        'image_library' => 'gd2',
                        'source_image' => $path . '/' . $image_data['file_name'],
                        'maintain_ratio' => false,
                        //  'create_thumb' => true,
                        'quality' => '20%',
                        'width' => 480,
                        'height' => 480,
                        'overwrite' => TRUE
                    ));
                    if ($this->image_lib->resize()) {
                        $key['product_id'] = $id;
                        $data = $this->model_app->getSelectedData('product_image', $key);
                        foreach ($data->result() as $d) {
                            echo img(array(
                                'src' => base_url() . "assets/product_image/" . $d->product_image,
                                'width' => 180,
                                'height' => 180,
                                'style' => 'margin:10px; padding:10px; background:#bbb'
                            ));
                        }
                    }
                }
                $no++;
            }
        }
    }

}

/* End of file product_image.php */
    /* Location: ./application/controllers/product_image.php */    