<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Slider extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'slider';
    private $control = 'admin/slider';
    private $folder_view = 'super/slider';
    private $pk = 'id';

    public function index() {
        $query_slider = "SELECT * FROM $this->table ORDER BY no_urut";
        $data = array(
            'data_slider' => $this->model_app->manualQuery($query_slider)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function edit() {
        renderSuper("$this->folder_view/edit");
    }

    function changeorder() {
        $query_slider = "SELECT * FROM $this->table ORDER BY no_urut";
        $data = array(
            'data_slider' => $this->model_app->manualQuery($query_slider)
        );
        renderSuper("$this->folder_view/ordering", $data);
    }

    function simpanData() {
        $title = $this->input->post('title');
        $order = $this->input->post('order');
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/slider');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'overwrite' => TRUE
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'title' => $title,
                        'no_urut' => $order,
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext']
                    );
                    $this->model_app->insertData($this->table, $data);
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'title' => $title,
                    'no_urut' => $order,
                );
                $this->model_app->insertData($this->table, $data);
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

    function hapusSlider() {
        $key['id'] = $this->uri->segment(4);
        $gambar = $this->uri->segment(5);
        $this->model_app->deleteData($this->table, $key);
        $pathFile = realpath(APPPATH . '../assets/slider/' . $gambar);
        unlink($pathFile);
        redirect($this->control);
    }

    function updateOrder() {
        $key['id'] = $this->input->post('id');
        $data['no_urut'] = $this->input->post('order');
        $cek = $this->model_app->getSelectedData($this->table, $data)->num_rows();
        if ($cek > 0) {
            echo "Nomor Order sudah digunakan!";
        } else {
            $this->model_app->updateData($this->table, $data, $key);
            echo "Berhasil Mengganti Nomor Order";
        }
    }

}

/* End of file slider.php */
/* Location: ./application/controllers/slider.php */