<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sub_menu extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'sub_menu';
    private $control = 'admin/sub_menu';
    private $folder_view = 'super/menu/sub_menu';
    private $pk = 'id_sub_menu';

    public function index() {
        $query_sub = "SELECT a.*,b.menu_name from $this->table a JOIN main_menu b on a.menu_id=b.id_menu ORDER BY b.id_menu";
        $data = array(
            'data_sub_menu' => $this->model_app->manualQuery($query_sub)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    public function tambah_data() {
        $key['id_sub_menu'] = '';
        $data = array(
            'data_main_menu' => $this->model_app->getAllData('main_menu'),
            'data_sub_menu' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('product_category')->result(),
            'data_page' => $this->model_app->getAllData('page')->result(),
        );
        renderSuper("$this->folder_view/insert", $data);
    }

    public function edit_data() {
        $key['id_sub_menu'] = $this->uri->segment(4);
        $data = array(
            'data_main_menu' => $this->model_app->getAllData('main_menu'),
            'data_sub_menu' => $this->model_app->getSelectedData($this->table, $key),
            'data_category' => $this->model_app->getAllData('product_category')->result(),
            'data_page' => $this->model_app->getAllData('page')->result(),
        );
        renderSuper("$this->folder_view/insert", $data);
    }

    public function changeorder() {
        $query_sub = "SELECT a.*,b.menu_name from $this->table a JOIN main_menu b on a.menu_id=b.id_menu";
        $data = array(
            'data_sub_menu' => $this->model_app->manualQuery($query_sub)
        );
        renderSuper("$this->folder_view/changeorder", $data);
    }

    function updateOrder() {
        $key['id_sub_menu'] = $this->input->post('id_sub_menu');
        $data['order'] = $this->input->post('order');
        $cek = $this->model_app->getSelectedData($this->table, $data)->num_rows();
        if ($cek > 0) {
            echo "Nomor Order sudah digunakan!";
        } else {
            $this->model_app->updateData($this->table, $data, $key);
            echo "Berhasil Mengganti Nomor Order";
        }
    }

    function simpanData() {
        $id_sub_menu = $this->input->post('id_sub_menu');
        $key['id_sub_menu'] = $id_sub_menu;
        $main_menu = $this->input->post('main_menu');
        $title = $this->input->post('title');
        $order = $this->input->post('order');
        $active = $this->input->post('active');
        $key_page = $this->input->post('key_page');

        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/menu');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '100%',
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'menu_id' => $main_menu,
                        'title' => $title,
                        'order' => $order,
                        'key_page' => $key_page,
                        'active' => $active,
                        'icon' => $data_upload['raw_name'] . $data_upload['file_ext'],
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->image_file;
                            $pathFile = realpath(APPPATH . '../assets/menu/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'menu_id' => $main_menu,
                    'title' => $title,
                    'order' => $order,
                    'key_page' => $key_page,
                    'active' => $active,
                );
                if ($cek->num_rows() > 0) {
                    $this->model_app->updateData($this->table, $data, $key);
                } else {
                    $this->model_app->insertData($this->table, $data);
                }
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

    function add_banner() {
        $key['id_sub_menu'] = $this->uri->segment(4);
        $data = array(
            'data_sub_menu' => $this->model_app->getSelectedData($this->table, $key),
        );
        renderSuper("$this->folder_view/add_banner", $data);
    }

    function simpanBanner() {
        $id_sub_menu = $this->input->post('id');
        $key['id_sub_menu'] = $id_sub_menu;
        $cek = $this->model_app->getSelectedData($this->table, $key);
        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/menu');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '100%',
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext'],
                    );
                    if ($cek->num_rows() > 0) {
                        foreach ($cek->result() as $c) {
                            $gambar = $c->image_file;
                            $pathFile = realpath(APPPATH . '../assets/menu/' . $gambar);
                            unlink($pathFile);
                        }
                        $this->model_app->updateData($this->table, $data, $key);
                    } else {
                        $this->model_app->insertData($this->table, $data);
                    }
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat! 1";
                }
            } else {
                echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat! 2";
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat! 3";
        }
    }

    function changeActive() {
        $key['id_sub_menu'] = $this->uri->segment(4);
        $data = array(
            'active' => 'Yes'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function changeNonActive() {
        $key['id_sub_menu'] = $this->uri->segment(4);
        $data = array(
            'active' => 'No'
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function deleteData() {
        $key['id_sub_menu'] = $this->uri->segment(4);
        $this->model_app->deleteData($this->table, $key);
        redirect($this->control);
    }

}

/* End of file sub_menu.php */
/* Location: ./application/controllers/sub_menu.php */