<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Testimony extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'contact_guestbook';
    private $control = 'admin/testimony';
    private $folder_view = 'super/testimony';
    private $pk = 'id';

    public function index() {
        $data = array(
            'data_testimony' => $this->model_app->getAllData($this->table)
        );
        renderSuper("$this->folder_view/data", $data);
    }

    function view_data() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'data_testimony' => $this->model_app->getSelectedData($this->table, $key)
        );
        renderSuper("$this->folder_view/view", $data);
    }

    function editData() {
        $key['id'] = $this->uri->segment(4);
        $data = array(
            'data_testimony' => $this->model_app->getSelectedData($this->table, $key)
        );
        renderSuper("$this->folder_view/edit", $data);
    }

    function changeAprrove() {
        $key['id'] = $this->uri->segment(4);
        $data['status'] = 1;
        $this->model_app->updateData($this->table, $data, $key);
        redirect($this->control);
    }

    function simpanData() {
        $key['id'] = $this->input->post('id');
        $nama = $this->input->post('nama');
        $alamat = $this->input->post('alamat');
        $no_telp = $this->input->post('no_telp');
        //$picture = $this->input->post('picture');
        $testimony = $this->input->post('testimony');
        $status = $this->input->post('status');


        if (isset($_FILES['userfile'])) {
            $path = realpath(APPPATH . '../assets/testimony');
            $this->upload->initialize(array(
                'upload_path' => $path,
                'allowed_types' => 'png|jpg|gif',
                'max_size' => '5000',
                'max_width' => '3000',
                'max_height' => '3000'
            ));
            if ($this->upload->do_upload()) {
                $data_upload = $this->upload->data();
                $this->image_lib->initialize(array(
                    'image_library' => 'gd2',
                    'source_image' => $path . '/' . $data_upload['file_name'],
                    'maintain_ratio' => false,
                    //  'create_thumb' => true,
                    'quality' => '20%',
                    'width' => 370,
                    'height' => 200,
                    'overwrite' => TRUE
                ));
                if ($this->image_lib->resize()) {
                    $data = array(
                        'name' => $nama,
                        'address' => $alamat,
                        'phone_no' => $no_telp,
                        'picture' => $data_upload['raw_name'] . $data_upload['file_ext'],
                        'testimony' => $testimony,
                        'status' => $status
                    );
                    $this->model_app->updateData($this->table, $data, $key);
                    redirect($this->control);
                } else {
                    echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
                }
            } else {
                $data = array(
                    'name' => $nama,
                    'address' => $alamat,
                    'phone_no' => $no_telp,
                    'testimony' => $testimony,
                    'status' => $status
                );
                $this->model_app->updateData($this->table, $data, $key);
                redirect($this->control);
            }
        } else {
            echo "Telah terjadi Kesalahan Yang tidak diinginkan Silahkan ulangi lagi beberapa saat!";
        }
    }

}

/* End of file testimony.php */
/* Location: ./application/controllers/testimony.php */