<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Websetting extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('model_app');
        $this->isLoggedIn();
    }

    function isLoggedIn() {
        $isLoggedIn = $this->session->userdata('isLoggedIn');
        if ($isLoggedIn == false) {
            $this->session->set_flashdata('message_red_password', 'LOGIN DULUUUU CUY !');
            redirect('admin/loginpage');
        }
    }

    private $table = 'web_setting';
    private $control = 'admin/kategori';
    private $folder_view = 'super/master_data/kategori';
    private $pk = 'id_kategori';

    public function index() {
        $key['id'] = 1;
        $data = array(
            'data_websetting' => $this->model_app->getSelectedData($this->table, $key)->result()
        );
        renderSuper('super/websetting', $data);
    }

    function updateData() {
        $key['id'] = $this->input->post('id');
        $web_title = $this->input->post('web_title');
        $meta_text = $this->input->post('meta_text');
        $meta_desc = $this->input->post('meta_desc');
        $meta_key = $this->input->post('meta_key');
        $email = $this->input->post('email');
        $address = $this->input->post('alamat');
        $no_telp = $this->input->post('no_telp');
        $no_fax = $this->input->post('no_fax');
        $wa = $this->input->post('whatsapp');
        $bb = $this->input->post('pin_bb');
        $fb = $this->input->post('facebook');
        $tw = $this->input->post('twitter');
        $gps = $this->input->post('gps');
        $ytb = $this->input->post('youtube');
        $rek_ps1 = $this->input->post('rekening_perusahaan1');
        $rek_ps2 = $this->input->post('rekening_perusahaan2');
        $rek_ps3 = $this->input->post('rekening_perusahaan3');
        $data = array(
            'title' => $web_title,
            'meta_text' => $meta_text,
            'meta_desc' => $meta_desc,
            'meta_keyword' => $meta_key,
            'email' => $email,
            'alamat' => $address,
            'no_telp' => $no_telp,
            'google_plus' => $gps,
            'youtube' => $ytb,
            'whatsapp' => $wa,
            'pin_bb' => $bb,
            'facebook' => $fb,
            'twitter' => $tw,
            'rekening_perusahaan1' => $rek_ps1,
            'rekening_perusahaan2' => $rek_ps2,
            'rekening_perusahaan3' => $rek_ps3,
        );
        $this->model_app->updateData($this->table, $data, $key);
        redirect('admin/websetting');
    }

}

/* End of file websetting.php */
/* Location: ./application/controllers/websetting.php */