<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Career extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    function __construct() {
        parent::__construct();
        $this->load->model('m_profile_content');
        $this->load->model("M_products", "m_products");
        $this->load->model("M_careers", "m_careers");
        $this->load->model("M_newsroom", "m_newsroom");
        $this->load->library('pagination');
    }

    public function index() {
        $data['title'] = "Career";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $header_aston2 = array(
            'src' => 'assets/images/header_aston.png',
            'alt' => '',
            'width' => '210',
            'height' => '60',
        );
        $data['header_aston2'] = img($header_aston2);

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $data['judul'] = "Lowongan Kerja";

        $alias = $this->uri->segment(1);
        $data['konten'] = $this->m_profile_content->get_konten($alias);
        $data["products_menu"] = $this->m_products->get_available_brands();
        $data["careers"] = $this->m_careers->get_available_careers(intval($this->uri->segment(3)), 3);

        $config['base_url'] = base_url("career/page/");
        $config['total_rows'] = $this->m_careers->get_available_careers_count();
        ;
        $config['per_page'] = 3;
        $config['uri_segment'] = 3;
        $config['first_link'] = 'First';
        $config['last_link'] = 'Last';
        $this->pagination->initialize($config);
        $data["pager"] = $this->pagination->create_links();

        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();

        
        $data['home'] = "";

        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_career', $data);
        $this->load->view('frontamazink/footer.php', $data);
    }

    function page() {
        $this->index();
    }

    function detail() {
        $data['title'] = "Career";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $header_aston2 = array(
            'src' => 'assets/images/header_aston.png',
            'alt' => '',
            'width' => '210',
            'height' => '50',
        );
        $data['header_aston2'] = img($header_aston2);

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $data['judul'] = "Lowongan Kerja";
        $id_careers = $this->uri->segment(3);
        $alias = $this->uri->segment(1);
        $data['konten'] = $this->m_profile_content->get_konten($alias);
        $data["products_menu"] = $this->m_products->get_available_brands();
        $data["career"] = $this->m_careers->get_careers_by_id($id_careers);
        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();

       
        $data['home'] = "";

        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_detail_career', $data);
        $this->load->view('frontamazink/footer.php', $data);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */