<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cart extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    function __construct() {
        parent::__construct();
        $this->load->model(array('m_profile_content', 'm_newsroom', 'm_products'));
        $this->load->model("M_cart", "m_cart");
        date_default_timezone_set('Asia/Jakarta');
    }

    function view($session_id) {
        $data['title'] = "Aston Printer Center | Cart";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
        $data['water'] = img('assets/images/water.png', array('width' => '50px', 'height' => '50px'));
        $data['water'] = "<img src='" . base_url() . "assets/images/water.png' width='20px' height='20px'>";
        $data['judul'] = "Cart";
        $data['slider'] = $this->m_profile_content->get_slider_produk();
        $data["products_menu"] = $this->m_products->get_available_brands();
        
        $data['cart'] = $this->m_cart->get_temp_cart($session_id);
        $data['session_id'] = $session_id;
        $this->load->view('frontamazink/v_cart', $data);
    }
    
    function update($session_id){
        $id_temp_cart = $this->input->post('id');
        $jumlah = $this->input->post('jumlah');
        
        $update_jum_temp_cart = $this->m_cart->update_jum_temp_cart($id_temp_cart,$jumlah);
        if($update_jum_temp_cart){
            $this->session->flashdata('msg_sukses', 'Keranjang belanja berhasil diupdate');
        }else{
            $this->session->flashdata('msg_sukses', 'Keranjang belanja berhasil diupdate');
        }
        redirect('cart/view/'.$session_id);
    }
    
    function hapus($id_cart){
        $session_id = $this->session->userdata('session_id');
        $delete_temp_cart = $this->m_cart->delete_product_temp_cart($id_cart);
        if($delete_temp_cart){
            $this->session->flashdata('msg_sukses', 'Keranjang belanja berhasil diupdate');
        }else{
            $this->session->flashdata('msg_sukses', 'Keranjang belanja berhasil diupdate');
        }
        redirect('cart/view/'.$session_id);
    }
    
    function checkout($session_id){
        $data['title'] = "Aston Printer Center | Checkout";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
        $data['water'] = img('assets/images/water.png', array('width' => '50px', 'height' => '50px'));
        $data['water'] = "<img src='" . base_url() . "assets/images/water.png' width='20px' height='20px'>";
        $data['judul'] = "Chekout";
        $data['slider'] = $this->m_profile_content->get_slider_produk();
        $data["products_menu"] = $this->m_products->get_available_brands();
       
        $data['session_id'] = $session_id;
        $this->load->view('frontamazink/v_checkout', $data);
    }
    
    function simpan_checkout($session_id){
        $nama = $this->input->post('nama');
        $email = $this->input->post('email');
        $alamat_pengiriman = $this->input->post('alamat_pengiriman');
        $no_contact = $this->input->post('no_contact');
        $tanggal = date('Y-m-d h:i:s');
        $status = "BARU";
        
        //generate nomor transaksi
        $get_last_no_trans = $this->db->query("SELECT nomortransaksi FROM trans_cart ORDER BY pk DESC LIMIT 0,1");
        $glnt = $get_last_no_trans->row();
        $last_no_trans = $glnt->nomortransaksi;
        $lnt = explode('-', $last_no_trans);
        $date_lnt = substr($lnt[1], 0, 8);
        $last_lnt = substr($lnt[1], 8, 3);
            if($date_lnt == date('Ymd')){
                if(substr($last_lnt,0,2) == 00){
                    if(substr($last_lnt,2,1) > 8){
                        $x = "010";
                    }else{
                        $x = "00".(substr($last_lnt,2,1)+1);
                    }
                }else if(substr($last_lnt,0,1) == 0){
                    if(substr($last_lnt,1,2) > 98){
                        $x = "100";
                    }else{
                        $x = "0".(substr($last_lnt,1,2)+1);
                    }
                }else{
                    if(substr($last_lnt,0,3) < 999){
                        $x = substr($last_lnt,0,3)+1;
                    }
                }
            }else{
                $x = "001";
            }
                
        $nomortransaksi = "AMZ-".date('Ymd').$x;

        $data = array(
            'nomortransaksi'   =>  $nomortransaksi,
            'nama'  =>  $nama,
            'email' =>  $email,
            'alamat_pengiriman' =>  $alamat_pengiriman,
            'tanggal'   =>  $tanggal,
            'no_contact'    =>  $no_contact,
            'status'    =>  $status
        );
        $trans_cart = $this->m_cart->simpan_trans_cart($session_id, $data);
        if($trans_cart['status']){
            $this->session->set_flashdata('msg_trans', 'Transaksi '.$nomortransaksi.' berhasil disimpan.');
            redirect('transaksi/view/'.$nomortransaksi);
        }
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */