<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Contact extends CI_Controller {

    function __construct() {
        parent::__construct();
    }

    public function index() {

        $data = array(
            'title' => "Amazink Contact",
            'meta_desc' => "Hubungi AMAZiNK Indonesia Sekarang",
            'met_key' => "Hubungi AMAZiNK Indonesia Sekarang",
            'home' => "",
        );
        renderFront("frontend/contact", $data);
    }

    public function send() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_message('required', 'Field %s harus diisi');

        $this->form_validation->set_rules('username', 'Username', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        //$this->form_validation->set_rules('subject', 'Subject', 'required');
        $this->form_validation->set_rules('message', 'Message', 'required');
        if ($this->form_validation->run()) {
            $sql = "INSERT INTO contact_guestbook(nama,email,subject,pesan,dateadded,datemodified) 
                        VALUES(?,?,?,?,NOW(),NOW())";
            $nama = $this->input->post("username", TRUE);
            $email = $this->input->post("email", TRUE);
            $subject = $nama . "[ $email ]"; //$this->input->post("subject",TRUE);
            $pesan = $this->input->post("message", TRUE);
            $simpan = $this->db->query($sql, array($nama, $email, $subject, $pesan));

            $this->session->set_flashdata("message_contact", "Terima kasih {$nama} telah mengisi form kontak kami");
            //$data["message_contact"] = "Terima kasih {$nama} telah mengisi form kontak kami";
            redirect('contact');
        } else {

            $this->session->set_flashdata("message_contact", "Maaf Data anda tidak lengkap");
            //$data["message_contact"] = "Terima kasih {$nama} telah mengisi form kontak kami";
            redirect('contact');
        }
    }

    public function outlets() {
        $data['title'] = "Aston Printer Center | Outlets";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $alias = $this->uri->segment(2);
        $data['konten'] = $this->m_profile_content->get_konten($alias);
        $data["products_menu"] = $this->m_products->get_available_brands();
        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();

        $this->load->view('front/top', $data);
        $this->load->view('front/v_outlets', $data);
        $this->load->view('front/bottom', $data);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */