<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of control
 *
 * @author Chaula Maliki <malikichaula@gmail.com>
 */
class Control extends CI_Controller {
    
    var $session_name = "webmaster_session";
    var $control_folder = "/control";
    
    function __construct() {
        parent::__construct();
        
    }
    
    function index(){
        if($this->is_session_valid() == FALSE){
            $this->control_login();
        }else{
            $this->control_home();
        }
    }
    
    private function is_session_valid(){
        if($this->session->userdata($this->session_name) == FALSE or $this->session->userdata("logged_in") == FALSE){
           return FALSE;
        }else{
            return TRUE;
        }
    }
    
    function control_home(){
        $this->load->view("/control/control_header");
        $this->load->view("/control/control_home_menu");
        $this->load->view("/control/control_footer");
    }
    
    private function control_login(){
        $this->load->view("/control/control_login");
    }
    
    function login(){
        
        $this->load->model("{$this->control_folder}/M_userlogin", "m_login");
        
        $username = $this->input->post("txt_username", TRUE);
        $password = $this->input->post("txt_password", TRUE);
        $ip_address = $this->input->ip_address();
        
        $hasil_login = $this->m_login->validate_login($username, $password, $ip_address);
        
        if($hasil_login["status"] == true && strlen($hasil_login["accountkey"]) == 32){
            $this->session->set_userdata(array($this->session_name => $hasil_login["accountkey"], "logged_in"=>$hasil_login["status"]));
            redirect("/control");
        }else{
            $this->control_login();
        }
        
    }
    
    function logout(){
        $this->session->sess_destroy();
        header("location:".site_url("/control"));
    }
    
    function profile($page_title="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_profile", "m_profile");
            $this->load->library('pagination');
            
            $profile = $this->m_profile->get_daftar_profile($page_num, 10);
            
            $config['base_url'] = base_url("control/profile/page/");
            $config['total_rows'] = $this->m_profile->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $message = $this->session->flashdata("message");
            
            $this->load->view("/control/control_profile",array("profile"=>$profile, "pager"=>$pager, "message"=>$message));
            
        }
    }    
    
    function profile_edit($profile_pk=0, $profile_title=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_profile", "m_profile");
            
            $profile_pk = $this->security->xss_clean($profile_pk);
            $profile_title = $this->security->xss_clean($profile_title);
            
            $profile = $this->m_profile->get_profile_by_pk($profile_pk);
            
            $this->load->view("/control/control_form_profile_editor",array("profile"=>$profile));
        }else{
            redirect("/control");
        }
    }    
    
    function profile_update(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_profile","m_profile");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_judul","Judul","required");
            //$this->form_validation->set_rules("txt_konten","Konten","required");
            $this->form_validation->set_rules("simpan_profile","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $alias = $this->input->post("alias",TRUE);
            $judul = $this->input->post("txt_judul",TRUE);
            $sub_judul = $this->input->post("txt_sub_judul",TRUE);
            $konten = $this->input->post("txt_konten", TRUE);
            
            if ($this->form_validation->run() == FALSE){
                $profile = $this->m_profile->get_profile_by_pk($pk);
                
		$this->load->view('/control/control_form_profile_editor', array("profile"=>$profile));
            }else{
                
                if($this->m_profile->update_profile($pk, $alias, $judul, $sub_judul, $konten)){
                    $this->session->set_flashdata("message",$judul);
                    redirect("/control/profile");
                }else{
                    redirect("/control/profile_edit/$pk/".$this->url_title($judul,"-", TRUE));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function images($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('pagination');
            
            $kategori = $this->m_images->get_daftar_kategori($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/images/page/");
            $config['total_rows'] = $this->m_images->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_image_kategori",array("folder"=>$kategori, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function image_kategori_edit($profile_pk=0, $profile_title=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            
            $profile_pk = $this->security->xss_clean($profile_pk);
            $profile_title = $this->security->xss_clean($profile_title);
            
            $profile = $this->m_images->get_kategori_by_pk($profile_pk);
            $this->load->view("/control/control_form_image_kategori",array("profile"=>$profile,"message"=>""));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_image_kategori(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_images","m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_kategori","Nama Folder","required");
            $this->form_validation->set_rules("txt_keterangan","Keterangan Folder","required");
            $this->form_validation->set_rules("simpan_image_kategori","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $nama_kategori = $this->input->post("txt_nama_kategori",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            
            if ($this->form_validation->run() == FALSE){
                $profile = $this->m_images->get_kategori_by_pk($pk);
            }else{
                $simpan = $this->m_images->simpan_image_kategori($pk,$nama_kategori, $keterangan);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/images");
                }else{
                    $profile = $this->m_images->get_kategori_by_pk($pk);
                    $this->load->view('/control/control_form_image_kategori', array("profile"=>$profile,"message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_image_folder($image_kategori_fk, $kategori_name, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $image_kategori_fk = intval($image_kategori_fk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_images","m_images");
            
            $result = $this->m_images->hapus_image_kategori($image_kategori_fk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/images");
            }else{
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/images");
            }
        }else{
            redirect("/control");
        }
        
        
    }
    
    function images_by_folder($kategori_id,$kategori_name,$page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('pagination');
            
            $images = $this->m_images->get_daftar_image(intval($kategori_id),intval($page_num), 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/images_by_folder/$kategori_id/$kategori_name/page/");
            $config['total_rows'] = $this->m_images->get_total_record_image(intval($kategori_id));;
            $config['per_page'] = 10;
            $config['uri_segment'] = 6;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_form_image_upload",array("daftar_image"=>$images,"kategori"=>$kategori_id,"kategori_name"=>$kategori_name, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function image_edit($kategori_id,$kategori_name,$image_id,$page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('pagination');
            
            $image_file = $this->m_images->get_image_by_pk($image_id, $kategori_id);
            $images = $this->m_images->get_daftar_image(intval($kategori_id),intval($page_num), 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/images_by_folder/$kategori_id/$kategori_name/page/");
            $config['total_rows'] = $this->m_images->get_total_record_image(intval($kategori_id));;
            $config['per_page'] = 10;
            $config['uri_segment'] = 6;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_form_image_upload",array("daftar_image"=>$images,"folder"=>$image_file,"kategori"=>$kategori_id,"kategori_name"=>$kategori_name, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function do_upload_img($page="page",$page_num=0){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_images","m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_gambar","Nama Gambar","required");
            $this->form_validation->set_rules("simpan_image_file","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');

            $pk = $this->input->post("pk",TRUE);
            $image_kategori_fk = $this->input->post("image_kategori_fk",TRUE);
            $nama_gambar = $this->input->post("txt_nama_gambar",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $page_num = intval($page_num);
            
            $kategori_name = $this->m_images->get_kategori_by_pk($image_kategori_fk);
            
            if ($this->form_validation->run() == FALSE){
                $this->load->library('pagination');
                $image_file = $this->m_images->get_image_by_pk($pk, $image_kategori_fk);
                $images = $this->m_images->get_daftar_image(intval($image_kategori_fk),intval($page_num), 10);

                $config['base_url'] = base_url("control/images_by_folder/$image_kategori_fk/{$kategori_name["nama_kategori"]}/page/");
                $config['total_rows'] = $this->m_images->get_total_record_image(intval($image_kategori_fk));;
                $config['per_page'] = 10;
                $config['uri_segment'] = 6;
                $this->pagination->initialize($config);
                $pager = $this->pagination->create_links();

                $this->load->view('/control/control_form_image_upload', array("daftar_image"=>$images,"folder"=>$image_file,"kategori"=>$image_kategori_fk,"kategori_name"=>$kategori_name["nama_kategori"], "pager"=>$pager,"message"=>$upload["message"]));
            }else{
                $upload = $this->m_images->do_upload($pk,$image_kategori_fk,$nama_gambar,$keterangan);
                if($upload["status"]){
                    $this->session->set_flashdata("message","gambar $nama_gambar berhasil disimpan");
                    redirect("/control/images_by_folder/$image_kategori_fk/".url_title($kategori_name["nama_kategori"], "-", TRUE));
                }else{
                    $this->load->library('pagination');
                    $image_file = $this->m_images->get_image_by_pk($pk, $image_kategori_fk);
                    $images = $this->m_images->get_daftar_image(intval($image_kategori_fk),intval($page_num), 10);
                    
                    $config['base_url'] = base_url("control/images_by_folder/$image_kategori_fk/{$kategori_name["nama_kategori"]}/page/");
                    $config['total_rows'] = $this->m_images->get_total_record_image(intval($image_kategori_fk));;
                    $config['per_page'] = 10;
                    $config['uri_segment'] = 6;
                    $this->pagination->initialize($config);
                    $pager = $this->pagination->create_links();
                    
                    $this->load->view('/control/control_form_image_upload', array("daftar_image"=>$images,"folder"=>$image_file,"kategori"=>$image_kategori_fk,"kategori_name"=>$kategori_name["nama_kategori"], "pager"=>$pager,"message"=>$upload["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_image($image_kategori_fk, $kategori_name,$image_pk, $image_name, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $image_pk = intval($image_pk);
            $image_kategori_fk = intval($image_kategori_fk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_images","m_images");
            
            $this->m_images->hapus_image_by_pk($image_pk, $image_kategori_fk);
            $kategori = $this->m_images->get_kategori_by_pk($image_kategori_fk);
            $this->session->set_flashdata("message","Gambar $image_name berhasil dihapus");
            redirect("/control/images_by_folder/$image_kategori_fk/".url_title($kategori["nama_kategori"],"-",TRUE));
            
        }else{
            redirect("/control");
        }
        
        
    }
    
    function products($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            $this->load->library('pagination');
            
            $kategori = $this->m_products->get_daftar_brand($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/products/page/");
            $config['total_rows'] = $this->m_products->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_product_brand",array("folder"=>$kategori, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function edit_brand($brand_fk=0, $brand_title=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $brand_fk = $this->security->xss_clean($brand_fk);
            $brand_title = $this->security->xss_clean($brand_title);
            
            $profile = $this->m_products->get_brand_by_pk($brand_fk);
            $image_folder = $this->m_images->get_all_kategori();
            $this->load->view("/control/control_form_product_brand",array("profile"=>$profile,"images_folder"=>$image_folder,"message"=>""));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_brand(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_products","m_products");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_brand","Nama Brand","required");
            $this->form_validation->set_rules("simpan_product_brand","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $nama_brand = $this->input->post("txt_nama_brand",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $image_folder = $this->input->post("image_folder",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            
            $fields = array("pk"=>$pk, "nama_brand"=>$nama_brand, "keterangan_brand"=>$keterangan, "image_kategori_fk"=>$image_folder, "is_published"=>$publish);
            $this->form_validation->run();
            
            if ($this->form_validation->run() == FALSE){
                $profile = $this->m_products->get_brand_by_pk($pk);
                $this->load->view('/control/control_form_product_brand', array("profile"=>$fields,"message"=>"Product Brand belum dapat disimpan"));
            }else{
                $simpan = $this->m_products->simpan_brand($pk, $nama_brand, $keterangan, $image_folder, $publish);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/products");
                }else{
                    $image_folder = $this->m_images->get_all_kategori();
                    $this->load->view('/control/control_form_product_brand', array("profile"=>$fields,"images_folder"=>$image_folder,"message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_brand($brand_fk, $brand_name, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $brand_fk = intval($brand_fk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_products","m_products");
            
            $result = $this->m_products->hapus_brand($brand_fk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/products");
            }else{
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/products");
            }
        }else{
            redirect("/control");
        }
        
    }
    
    function product_sub_brand($brand_fk, $brand_name,$page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $brand_fk = intval($brand_fk);
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            $this->load->library('pagination');
            
            $kategori = $this->m_products->get_daftar_sub_brand($brand_fk,$page_num, 10);
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/products/sub_brand/page/");
            $config['total_rows'] = $this->m_products->get_total_record();
            $config['per_page'] = 10;
            $config['uri_segment'] = 5;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_product_sub_brand",array("folder"=>$kategori, "brand_fk"=>$brand["pk"], "nama_brand"=>$brand["nama_brand"], "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function edit_sub_brand($brand_fk, $brand_title, $sub_brand_fk=0, $sub_brand_name=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            
            $brand_fk = intval($this->security->xss_clean($brand_fk));
            $sub_brand_fk = intval($this->security->xss_clean($sub_brand_fk));
            $brand_fk = $this->security->xss_clean($brand_fk);
            $brand_title = $this->security->xss_clean($brand_title);
            
            $profile = $this->m_products->get_sub_brand_by_pk($sub_brand_fk, $brand_fk);
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            
            $this->load->view("/control/control_form_product_sub_brand",array("profile"=>$profile,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"message"=>""));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_sub_brand(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_products","m_products");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_sub_brand","Nama Sub Brand","required");
            $this->form_validation->set_rules("simpan_product_sub_brand","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $nama_sub_brand = $this->input->post("txt_nama_sub_brand",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $brand_fk = $this->input->post("brand_fk",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            
            $fields = array("pk"=>$pk, "nama_sub_brand"=>$nama_sub_brand, "keterangan_sub_brand"=>$keterangan, "product_brand_fk"=>$brand_fk, "is_published"=>$publish);
            $this->form_validation->run();
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            if ($this->form_validation->run() == FALSE){
                $this->load->view('/control/control_form_product_sub_brand', array("profile"=>$fields,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"message"=>"Product Sub Brand belum dapat disimpan"));
            }else{
                $simpan = $this->m_products->simpan_sub_brand($pk, $brand_fk, $nama_sub_brand, $keterangan, $publish);
                
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/product_sub_brand/{$brand["pk"]}/".  url_title($brand["nama_brand"], "-", TRUE));
                }else{
                    $this->load->view('/control/control_form_product_sub_brand', array("profile"=>$fields,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_sub_brand($brand_fk, $brand_name,$pk,$nama_sub_brand, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $brand_fk = intval($brand_fk);
            $brand_name = $this->security->xss_clean($brand_name);
            $pk = intval($pk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_products","m_products");
            
            $result = $this->m_products->hapus_sub_brand($pk,$brand_fk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/product_sub_brand/$brand_fk/$brand_name");
            }else{
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/product_sub_brand/$brand_fk/$brand_name");
            }
        }else{
            redirect("/control");
        }
       
    }
    
    function product_sub_brand_item($brand_fk,$sub_brand_fk, $sub_brand_name,$page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $sub_brand_fk = intval($sub_brand_fk);
            $brand_fk = intval($brand_fk);
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            $this->load->library('pagination');
            
            $sub_brand = $this->m_products->get_sub_brand_by_pk($sub_brand_fk, $brand_fk);
            $brand = $this->m_products->get_brand_by_pk($sub_brand["product_brand_fk"]);
            $items = $this->m_products->get_daftar_sub_brand_item($sub_brand_fk,$brand["pk"],$page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/product_sub_brand_item/$brand_fk/$sub_brand_fk/$sub_brand_name/page/");
            $config['total_rows'] = $this->m_products->get_subbrand_item_total_record($brand_fk, $sub_brand_fk);
            $config['per_page'] = 10;
            $config['uri_segment'] = 7;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_product_sub_brand_item",array("folder"=>$items, "brand_fk"=>$brand["pk"], "nama_brand"=>$brand["nama_brand"],"sub_brand_fk"=>$sub_brand_fk, "nama_sub_brand"=>$sub_brand["nama_sub_brand"], "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function edit_sub_brand_item($brand_fk,$brand_title, $sub_brand_fk, $sub_brand_name, $item_pk=0, $item_name=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_products", "m_products");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            
            $brand_fk = intval($this->security->xss_clean($brand_fk));
            $sub_brand_fk = intval($this->security->xss_clean($sub_brand_fk));
            $brand_fk = $this->security->xss_clean($brand_fk);
            $brand_title = $this->security->xss_clean($brand_title);
            $item_pk = intval($this->security->xss_clean($item_pk));
            
            $profile = $this->m_products->get_sub_brand_item_by_pk($item_pk, $sub_brand_fk, $brand_fk);
            $sub_brand = $this->m_products->get_sub_brand_by_pk($sub_brand_fk, $brand_fk);
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            $images = $this->m_images->get_daftar_image_all($brand["image_kategori_fk"]);
            
            $this->load->view("/control/control_form_product_sub_brand_item",array("profile"=>$profile,"images"=>$images,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"sub_brand_fk"=>$sub_brand["pk"],"nama_sub_brand"=>$sub_brand["nama_sub_brand"],"message"=>""));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_sub_brand_item(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_products","m_products");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_product","Nama Product","required");
            $this->form_validation->set_rules("simpan_product_sub_brand_item","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $brand_fk = $this->input->post("brand_fk",TRUE);
            $sub_brand_fk = $this->input->post("sub_brand_fk",TRUE);
            $nama_product = $this->input->post("txt_nama_product",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $gambar_fk = $this->input->post("rb_pilih",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            $harga = $this->input->post("txt_harga",TRUE);
            
            $fields = array("pk"=>$pk, "nama_product"=>$nama_product, "keterangan_product"=>$keterangan, "product_brand_fk"=>$brand_fk, "product_sub_brand_fk"=>$sub_brand_fk, "is_published"=>$publish, "gambar_fk"=>$gambar_fk);
            $profile = $this->m_products->get_sub_brand_item_by_pk($pk, $sub_brand_fk, $brand_fk);
            $sub_brand = $this->m_products->get_sub_brand_by_pk($sub_brand_fk, $brand_fk);
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            $images = $this->m_images->get_daftar_image_all($brand["image_kategori_fk"]);
            
            $this->form_validation->run();
            $brand = $this->m_products->get_brand_by_pk($brand_fk);
            if ($this->form_validation->run() == FALSE){
                $this->load->view("/control/control_form_product_sub_brand_item",array("profile"=>$profile,"images"=>$images,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"sub_brand_fk"=>$sub_brand["pk"],"nama_sub_brand"=>$sub_brand["nama_sub_brand"],"message"=>"Periksa kembali input anda"));
            }else{
                $simpan = $this->m_products->simpan_sub_brand_item($pk, $brand_fk, $sub_brand_fk, $nama_product, $keterangan, $publish, $gambar_fk, $harga);
                
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/product_sub_brand_item/{$brand["pk"]}/{$sub_brand["pk"]}/".  url_title($sub_brand["nama_sub_brand"], "-", TRUE));
                }else{
                    $this->load->view("/control/control_form_product_sub_brand_item",array("profile"=>$profile,"images"=>$images,"brand_fk"=>$brand["pk"],"nama_brand"=>$brand["nama_brand"],"sub_brand_fk"=>$sub_brand["pk"],"nama_sub_brand"=>$sub_brand["nama_sub_brand"],"message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_sub_brand_item($brand_fk,$sub_brand_fk,$item_pk,$nama_sub_brand_item, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $brand_fk = intval($brand_fk);
            $nama_sub_brand_item = $this->security->xss_clean($nama_sub_brand_item);
            $item_pk = intval($item_pk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_products","m_products");
            
            $result = $this->m_products->hapus_sub_brand_item($item_pk,$sub_brand_fk);
            $sub_brand = $this->m_products->get_sub_brand_by_pk($sub_brand_fk, $brand_fk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/product_sub_brand_item/$brand_fk/$sub_brand_fk/".  url_title($sub_brand["nama_sub_brand"], "-", TRUE));
            
        }else{
            redirect("/control");
        }
       
    }
    
    function services($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_services", "m_services");
            $this->load->library('pagination');
            
            $kategori = $this->m_services->get_daftar_service($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/services/page/");
            $config['total_rows'] = $this->m_services->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_services",array("services"=>$kategori, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function service_edit($service_pk=0, $service_title=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_services", "m_services");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            
            $service_pk = $this->security->xss_clean($service_pk);
            $service_title = $this->security->xss_clean($service_title);
            $message = $this->session->flashdata("message");
            $profile = $this->m_services->get_service_by_pk($service_pk);
            $image_folder = $this->m_images->get_all_kategori();
            $images = $this->m_images->get_daftar_image_all($profile["image_kategori_fk"]);
            $image_view = $this->load->view("/control/radio_image_list", array("images"=>$images,"pembanding"=>$profile["gambar_fk"]), TRUE);
            //print_r($profile);
            $this->load->view("/control/control_form_service",array("profile"=>$profile,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>$message));
        }else{
            redirect("/control");
        }
    } 
    
    function radio_image_list($image_folder, $pembanding){
        $this->load->model("{$this->control_folder}/M_images", "m_images");
            
        $image_folder = $this->security->xss_clean($image_folder);
        $pembanding = $this->security->xss_clean($pembanding);
        $images = $this->m_images->get_daftar_image_all($image_folder);
        $this->load->view("/control/radio_image_list", array("images"=>$images,"pembanding"=>$pembanding));
        
    } 
    
    function simpan_service(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_services","m_services");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_service","Nama Service","required");
            $this->form_validation->set_rules("simpan_service","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $nama_service = $this->input->post("txt_nama_service",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $image_folder_fk = $this->input->post("cb_image_folder",TRUE);
            $gambar_fk = $this->input->post("rb_pilih",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            $resume = $this->input->post("txt_resume",TRUE);
            
            $fields = array("pk"=>$pk, "nama_service"=>$nama_service, "resume_service"=>$resume, "keterangan_service"=>$keterangan, "image_kategori_fk"=>$image_folder_fk, "gambar_fk"=>$gambar_fk, "is_published"=>$publish);
            $this->form_validation->run();
            
            $image_folder = $this->m_images->get_all_kategori();
            $images = $this->m_images->get_daftar_image_all($image_folder_fk);
            $image_view = $this->load->view("/control/radio_image_list", array("images"=>$images,"pembanding"=>$gambar_fk), TRUE);
            if ($this->form_validation->run() == FALSE){
                $this->load->view("/control/control_form_service",array("profile"=>$fields,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>"Product Brand belum dapat disimpan"));
                
            }else{
                $simpan = $this->m_services->simpan_service($pk, $nama_service, $resume, $keterangan, $image_folder_fk, $gambar_fk, $publish);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/services");
                }else{
                    //$image_folder_fk = $this->m_images->get_all_kategori();
                    $this->load->view("/control/control_form_service",array("profile"=>$fields,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_service($service_pk,$nama_service, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $service_pk = intval($service_pk);
            $nama_service = $this->security->xss_clean($nama_service);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_services","m_services");
            
            $result = $this->m_services->hapus_service($service_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/services");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function newsroom($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_newsroom", "m_newsroom");
            $this->load->library('pagination');
            
            $kategori = $this->m_newsroom->get_daftar_berita($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/newsroom/page/");
            $config['total_rows'] = $this->m_newsroom->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_newsroom",array("services"=>$kategori, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function berita_edit($berita_pk=0, $judul_berita=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_newsroom", "m_newsroom");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            
            $berita_pk = $this->security->xss_clean($berita_pk);
            $judul_berita = $this->security->xss_clean($judul_berita);
            $message = $this->session->flashdata("message");
            $profile = $this->m_newsroom->get_berita_by_pk($berita_pk);
            $image_folder = $this->m_images->get_all_kategori();
            $images = $this->m_images->get_daftar_image_all($profile["image_kategori_fk"]);
            $image_view = $this->load->view("/control/radio_image_list", array("images"=>$images,"pembanding"=>$profile["gambar_fk"]), TRUE);
            //print_r($profile);
            $this->load->view("/control/control_form_newsroom",array("profile"=>$profile,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>$message));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_berita(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_newsroom","m_newsroom");
            $this->load->model("{$this->control_folder}/M_images", "m_images");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_judul_berita","Judul Berita","required");
            $this->form_validation->set_rules("txt_tag","Tags Berita","required");
            $this->form_validation->set_rules("txt_isi_berita","Isi Berita","required");
            $this->form_validation->set_rules("simpan_berita","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = intval($this->input->post("pk",TRUE));
            $judul_berita = $this->input->post("txt_judul_berita",TRUE);
            $isi_berita = $this->input->post("txt_isi_berita",TRUE);
            $image_folder_fk = $this->input->post("cb_image_folder",TRUE);
            $gambar_fk = $this->input->post("rb_pilih",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            $tag_berita = $this->input->post("txt_tag",TRUE);
            $tanggal_publish = $this->input->post("txt_tanggal_publish",TRUE);
            
            $fields = array("pk"=>$pk, "judul_berita"=>$judul_berita, "isi_berita"=>$isi_berita, "image_kategori_fk"=>$image_folder_fk, "gambar_fk"=>$gambar_fk, "is_published"=>$publish, "tag_berita"=>$tag_berita, "tanggal_publish"=>$tanggal_publish );
            $this->form_validation->run();
            
            $image_folder = $this->m_images->get_all_kategori();
            $images = $this->m_images->get_daftar_image_all($image_folder_fk);
            $image_view = $this->load->view("/control/radio_image_list", array("images"=>$images,"pembanding"=>$gambar_fk), TRUE);
            if ($this->form_validation->run() == FALSE or $tanggal_publish=="0000-00-00"){
                $this->load->view("/control/control_form_newsroom",array("profile"=>$fields,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>"Berita belum dapat disimpan"));
                
            }else{
                $simpan = $this->m_newsroom->simpan_berita($pk, $judul_berita, $isi_berita, $image_folder_fk, $gambar_fk, $publish, $tag_berita, $tanggal_publish);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/newsroom");
                }else{
                    $this->load->view("/control/control_form_newsroom",array("profile"=>$fields,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_berita($berita_pk,$judul_berita, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $berita_pk = intval($berita_pk);
            $judul_berita = $this->security->xss_clean($judul_berita);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_newsroom","m_newsroom");
            
            $result = $this->m_newsroom->hapus_berita($berita_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/newsroom");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function careers($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_careers", "m_careers");
            $this->load->library('pagination');
            
            $kategori = $this->m_careers->get_daftar_careers($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/careers/page/");
            $config['total_rows'] = $this->m_careers->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_careers",array("services"=>$kategori, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function career_edit($career_pk=0, $judul_career=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_careers", "m_careers");
            
            $career_pk = $this->security->xss_clean($career_pk);
            $judul_career = $this->security->xss_clean($judul_career);
            $message = $this->session->flashdata("message");
            $profile = $this->m_careers->get_career_by_pk($career_pk);
            $this->load->view("/control/control_form_career",array("profile"=>$profile, "message"=>$message));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_career(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_careers","m_careers");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_judul_career","Judul Career","required");
            $this->form_validation->set_rules("txt_date_published","Tanggal Publish","required");
            $this->form_validation->set_rules("txt_tanggal_berlaku","Berlaku Sampai","required");
            $this->form_validation->set_rules("txt_keterangan_career","Isi Career","required");
            $this->form_validation->set_rules("simpan_career","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = intval($this->input->post("pk",TRUE));
            $judul_career = $this->input->post("txt_judul_career",TRUE);
            $keterangan_career = $this->input->post("txt_keterangan_career",TRUE);
            $date_published = $this->input->post("txt_date_published",TRUE);
            $berlaku_sampai = $this->input->post("txt_tanggal_berlaku",TRUE);
            
            $fields = array("pk"=>$pk, "judul_career"=>$judul_career, "keterangan_career"=>$keterangan_career, "date_published"=>$date_published, "berlaku_sampai_tanggal"=>$berlaku_sampai );
            $this->form_validation->run();
            
            if ($this->form_validation->run() == FALSE){
                $this->load->view("/control/control_form_career",array("profile"=>$fields, "message"=>"Berita belum dapat disimpan"));
                
            }else{
                $simpan = $this->m_careers->simpan_career($pk, $judul_career, $keterangan_career, $date_published, $berlaku_sampai);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/careers");
                }else{
                    $this->load->view("/control/control_form_career",array("profile"=>$fields,"image_folder"=>$image_folder,"images"=>$image_view, "message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_career($career_pk,$judul_career, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $career_pk = intval($career_pk);
            $judul_career = $this->security->xss_clean($judul_career);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_careers","m_careers");
            
            $result = $this->m_careers->hapus_career($career_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/careers");
            
        }else{
            redirect("/control");
        }
       
    }
 
    function downloads($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_downloads", "m_downloads");
            $this->load->library('pagination');
            
            $downloads = $this->m_downloads->get_daftar_download($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/downloads/page/");
            $config['total_rows'] = $this->m_downloads->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_downloads",array("services"=>$downloads, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function download_edit($download_pk=0, $nama_download=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_downloads", "m_downloads");
            
            $download_pk = $this->security->xss_clean($download_pk);
            $nama_download = $this->security->xss_clean($nama_download);
            $message = $this->session->flashdata("message");
            $profile = $this->m_downloads->get_download_by_pk($download_pk);
            $this->load->view("/control/control_form_downloads",array("profile"=>$profile, "message"=>$message));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_download(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_downloads","m_downloads");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama_download","Nama Download","required");
            $this->form_validation->set_rules("simpan_download","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = intval($this->input->post("pk",TRUE));
            $nama_download = $this->input->post("txt_nama_download",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            
            $fields = array("pk"=>$pk, "nama_download"=>$nama_download, "is_published"=>$publish);
            $this->form_validation->run();
            
            if ($this->form_validation->run() == FALSE){
                $this->load->view("/control/control_form_downloads",array("profile"=>$fields, "message"=>"Download belum dapat disimpan"));
                
            }else{
                $simpan = $this->m_downloads->simpan_download($pk, $nama_download, $publish);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/downloads");
                }else{
                    $this->load->view("/control/control_form_downloads",array("profile"=>$fields, "message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_download($download_pk,$nama_download, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $download_pk = intval($download_pk);
            $nama_download = $this->security->xss_clean($nama_download);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_downloads","m_downloads");
            
            $result = $this->m_downloads->hapus_download_by_pk($download_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/downloads");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function videos($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_videos", "m_videos");
            $this->load->library('pagination');
            
            $videos = $this->m_videos->get_daftar_video($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/videos/page/");
            $config['total_rows'] = $this->m_videos->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_videos",array("videos"=>$videos, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function video_edit($video_pk=0, $service_title=""){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_videos", "m_videos");
            
            $video_pk = $this->security->xss_clean($video_pk);
            $service_title = $this->security->xss_clean($service_title);
            $message = $this->session->flashdata("message");
            $profile = $this->m_videos->get_video_by_pk($video_pk);
            $this->load->view("/control/control_form_video",array("profile"=>$profile, "message"=>$message));
        }else{
            redirect("/control");
        }
    } 
    
    function simpan_video(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_videos","m_videos");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_judul_video","Judul Video","required");
            $this->form_validation->set_rules("simpan_video","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $judul_video = $this->input->post("txt_judul_video",TRUE);
            $link_video = $this->input->post("txt_link_video",TRUE);
            $keterangan = $this->input->post("txt_keterangan",TRUE);
            $publish = $this->input->post("chk_publish",TRUE);
            
            $fields = array("pk"=>$pk, "judul"=>$judul_video, "keterangan"=>$keterangan, "link"=>$link_video, "is_published"=>$publish);
            $this->form_validation->run();
            
            if ($this->form_validation->run() == FALSE){
                $this->load->view("/control/control_form_video",array("profile"=>$fields, "message"=>"Video belum dapat disimpan"));
                
            }else{
                $simpan = $this->m_videos->simpan_video($pk, $judul_video, $keterangan, $link_video, $publish);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/videos");
                }else{
                    //$image_folder_fk = $this->m_images->get_all_kategori();
                    $this->load->view("/control/control_form_video",array("profile"=>$fields, "message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_video($video_pk,$judul_video, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $video_pk = intval($video_pk);
            $judul_video = $this->security->xss_clean($judul_video);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_videos","m_videos");
            
            $result = $this->m_videos->hapus_video($video_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/videos");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function contacts($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_guestbook", "m_guestbook");
            $this->load->library('pagination');
            
            $contacts = $this->m_guestbook->get_daftar_guestbook($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/contacts/page/");
            $config['total_rows'] = $this->m_guestbook->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_contacts",array("contacts"=>$contacts, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function delete_contact($contact_pk,$judul_contact, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $contact_pk = intval($contact_pk);
            $judul_contact = $this->security->xss_clean($judul_contact);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_guestbook","m_guestbook");
            
            $result = $this->m_guestbook->hapus_guestbook($contact_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/contacts");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function contact_read($contact_pk){
        
        if($this->is_session_valid()){
            $contact_pk = intval($contact_pk);
            
            $this->load->model("{$this->control_folder}/M_guestbook","m_guestbook");
            
            $result = $this->m_guestbook->get_guestbook_by_pk($contact_pk);
                        
            $this->load->view("/control/control_contact_reader", $result);
            
        }else{
            redirect("/control");
        }
       
    }
    
	function franchise($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_franchise", "m_franchise");
            $this->load->library('pagination');
            
            $contacts = $this->m_franchise->get_daftar_franchise($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/franchise/page/");
            $config['total_rows'] = $this->m_franchise->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_franchise",array("contacts"=>$contacts, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function delete_franchise($franchise_pk,$nama, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $franchise_pk = intval($franchise_pk);
            $nama = $this->security->xss_clean($nama);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_franchise","m_franchise");
            
            $result = $this->m_franchise->hapus_franchise($franchise_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/franchise");
            
        }else{
            redirect("/control");
        }
       
    }
    
    function franchise_read($franchise_pk){
        
        if($this->is_session_valid()){
            $franchise_pk = intval($franchise_pk);
            
            $this->load->model("{$this->control_folder}/M_franchise","m_franchise");
            
            $result = $this->m_franchise->get_franchise_by_pk($franchise_pk);
            echo str_ireplace("\n","<br />",$result["detail_all"]);          
            //$this->load->view("/control/control_franchise_reader", $result);
            
        }else{
            redirect("/control");
        }
       
    }
    
    function transaksi($status="baru", $page ="page", $page_num=0){
        if($this->is_session_valid()){
            if($this->uri->segment(3,0)){
                $status = $this->uri->segment(3);
            }else{
                $status = "baru";
            }
            
            $this->load->model("{$this->control_folder}/M_transaksi", "m_transaksi");
            $this->load->library('pagination');
            
            $transaksi = $this->m_transaksi->get_daftar_transaksi($page_num, 10, $status);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/transaksi/".$status."/page/");
            $config['total_rows'] = $this->m_transaksi->get_total_record($status);;
            $config['per_page'] = 10;
            $config['uri_segment'] = 5;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_transaksi",array("transaksi"=>$transaksi, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function edit_transaksi($id_transaksi=0){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_transaksi", "m_transaksi");
            $transaksi = $this->m_transaksi->get_transaksi_by_pk($id_transaksi);
            $this->load->view("/control/control_form_transaksi",array("transaksi"=>$transaksi,"message"=>""));
        }else{
            redirect("/control");
        }
    }
    
    function simpan_transaksi(){
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_transaksi","m_transaksi");
            $this->load->library('form_validation');
            
            $this->form_validation->set_rules("txt_nama","Nama","required");
            $this->form_validation->set_rules("txt_email","Email","required|valid_email");
            $this->form_validation->set_rules("txt_alamat_pengiriman","Alamat Pengiriman","required");
            $this->form_validation->set_rules("simpan_transaksi","Action Button Invalid","required");
            
            $this->form_validation->set_message('required', 'Field %s harus diisi');
            
            $pk = $this->input->post("pk",TRUE);
            $nomortransaksi = $this->input->post("nomortransaksi",TRUE);
            $nama = $this->input->post("txt_nama",TRUE);
            $email = $this->input->post("txt_email",TRUE);
            $alamat_pengiriman = $this->input->post("txt_alamat_pengiriman",TRUE);
            $no_contact = $this->input->post("txt_no_contact",TRUE);
            $status = $this->input->post("txt_status",TRUE);
            
            $fields = array("pk"=>$pk, "nomortransaksi"=>$nomortransaksi, "nama"=>$nama, "email"=>$email, "alamat_pengiriman"=>$alamat_pengiriman, "no_contact"=>$no_contact, "status"=>$status);
            $this->form_validation->run();
            
            if ($this->form_validation->run() == FALSE){
                $profile = $this->m_transaksi->get_transaksi_by_pk($pk);
                $this->load->view('/control/control_form_transaksi', array("transaksi"=>$fields,"message"=>"Transaksi belum dapat disimpan"));
            }else{
                $simpan = $this->m_transaksi->simpan_transaksi($pk, $nama, $email, $alamat_pengiriman, $no_contact, $status);
                if($simpan["status"]){
                    $this->session->set_flashdata("message",$simpan["message"]);
                    redirect("/control/detail_transaksi/".$pk);
                }else{
                    $this->load->view('/control/control_form_transaksi', array("transaksi"=>$fields,"message"=>$simpan["message"]));
                }
                
            }
            
        }else{
            redirect("/control");
        }
    }
    
    function delete_transaksi($pk, $nomortransaksi){
        
        if($this->is_session_valid()){
            $this->load->model("{$this->control_folder}/M_transaksi","m_transaksi");
            
            $result = $this->m_transaksi->hapus_transaksi($pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/transaksi");
            }else{
                $this->session->set_flashdata("message",$result["message"]);
                redirect("/control/transaksi");
            }
        }else{
            redirect("/control");
        }
        
    }
    
    function detail_transaksi($id_trans,$page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_transaksi", "m_transaksi");
            $this->load->library('pagination');
            
            $transaksi = $this->m_transaksi->get_detail_transaksi($id_trans, $page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/detail_transaksi/".$id_trans."/page/");
            $config['total_rows'] = $this->m_transaksi->get_total_record_detail($id_trans);;
            $config['per_page'] = 10;
            $config['uri_segment'] = 5;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $edit = $this->m_transaksi->get_transaksi_by_pk($id_trans);
            
            $this->load->view("/control/control_transaksi_detail",array("transaksi"=>$transaksi, "pager"=>$pager, "message"=>$message, "edit"=>$edit));
            
        }
    }
    
    function reseller($page ="page", $page_num=0){
        if($this->is_session_valid()){
            
            $this->load->model("{$this->control_folder}/M_reseller", "m_reseller");
            $this->load->library('pagination');
            
            $reseller = $this->m_reseller->get_daftar_reseller($page_num, 10);
            $message = $this->session->flashdata("message");
            
            $config['base_url'] = base_url("control/reseller/page/");
            $config['total_rows'] = $this->m_reseller->get_total_record();;
            $config['per_page'] = 10;
            $config['uri_segment'] = 4;
            $this->pagination->initialize($config);
            $pager = $this->pagination->create_links();
            
            $this->load->view("/control/control_reseller",array("reseller"=>$reseller, "pager"=>$pager, "message"=>$message));
            
        }
    }
    
    function reseller_read($reseller_pk){
        
        if($this->is_session_valid()){
            $reseller_pk = intval($reseller_pk);
            
            $this->load->model("{$this->control_folder}/M_reseller","m_reseller");
            
            $result = $this->m_reseller->get_reseller_by_pk($reseller_pk);
                        
            $this->load->view("/control/control_reseller_reader", $result);
            
        }else{
            redirect("/control");
        }
       
    }
    
    function delete_reseller($reseller_pk, $page="page",$page_num=0){
        
        if($this->is_session_valid()){
            $reseller_pk = intval($reseller_pk);
            $page_num = intval($page_num);
            
            $this->load->model("{$this->control_folder}/M_reseller","m_reseller");
            
            $result = $this->m_reseller->hapus_reseller($reseller_pk);
            if($result["status"]){
                $this->session->set_flashdata("message",$result["message"]);
            }else{
                $this->session->set_flashdata("message",$result["message"]);
            }
            
            redirect("/control/reseller");
            
        }else{
            redirect("/control");
        }
       
    }
}
?>