<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Download extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct()
    {
        parent::__construct();
		$this->load->model(array('m_profile_content','m_download','m_newsroom'));
                $this->load->model("M_products", "m_products");
	}
	
	public function index(){
		$data['title']="Download";
		$data['header_aston']=img('assets/images/header_aston.png');
		
		$data['header_link_fb']=img('assets/images/fb_gray.png');
		$data['header_link_twitter']=img('assets/images/twitter_gray.png');
		$data['header_link_gplus']=img('assets/images/gplus_gray.png');
		$data['header_link_blogger']=img('assets/images/blogger_gray.png');
		
		$data['judul']="Download Archive";
		$data['list_download'] = $this->m_download->get_list_download();
		$data['link_image_brands'] = $this->m_products->get_image_brands();
		$data['latest_news'] = $this->m_newsroom->get_latest_news();
		
		$alias = $this->uri->segment(1);
		$data['konten']=$this->m_profile_content->get_konten($alias);
                $data["products_menu"] = $this->m_products->get_available_brands();
		
		$this->load->view('front/v_download',$data);
	}
	
	function file(){
		$this->load->helper('download');
		$name = $this->uri->segment('3');
                
                if(file_exists("download_files/{$name}") && is_file("download_files/{$name}")){
                    $data = file_get_contents("download_files/{$name}"); // Read the file's contents
                }else{
                    $data = file_get_contents("download_files/file_not_found.html"); // Read the file's contents
                    $name = "file_not_found.html";
                }

		force_download($name, $data); 
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */