<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Franchise extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct(){
            parent::__construct();
            $this->load->model(array('m_profile_content','m_newsroom'));
            $this->load->model("M_products", "m_products");
	}
	
	public function index(){
            $data['title']="Franchise";
            $data['header_aston']=img('assets/images/header_aston.png');
            
            $data['header_link_fb']=img('assets/images/fb_gray.png');
            $data['header_link_twitter']=img('assets/images/twitter_gray.png');
            $data['header_link_gplus']=img('assets/images/gplus_gray.png');
            $data['header_link_blogger']=img('assets/images/blogger_gray.png');

            $data['judul']="Franchise";

            $alias = $this->uri->segment(1);
            $data['konten']=$this->m_profile_content->get_konten($alias);
            $data["products_menu"] = $this->m_products->get_available_brands();
            $data["message_contact"] = $this->session->flashdata("message_contact");
            
            $data['link_image_brands'] = $this->m_products->get_image_brands();
            $data['latest_news'] = $this->m_newsroom->get_latest_news();

            $this->load->view('front/top',$data);
            $this->load->view('front/v_franchise',$data);
            $this->load->view('front/bottom',$data);
	}
	
	public function send(){
            $data['header_aston']=img('assets/images/header_aston.png');
            $data['header_link_fb']=img('assets/images/fb.png');
            $data['header_link_twitter']=img('assets/images/twitter.png');
            $data['header_link_gplus']=img('assets/images/gplus.png');
            $data['header_link_blogger']=img('assets/images/blogger.png');
            $data['link_image_brands'] = $this->m_products->get_image_brands();
            $data['latest_news'] = $this->m_newsroom->get_latest_news();
			
            $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
            $this->form_validation->set_message('required', 'Field %s harus diisi');
			
            $this->form_validation->set_rules('gender', 'Nama lengkap', 'required');
            $this->form_validation->set_rules('nama_lengkap', 'Nama lengkap', 'required');
            $this->form_validation->set_rules('usia', 'Usia', 'required|numeric');
            $this->form_validation->set_rules('kewarganegaraan', 'Kewarganegaraan', 'required');
            $this->form_validation->set_rules('alamat', 'Alamat', 'required');
            $this->form_validation->set_rules('kota', 'Kota', 'required');
            $this->form_validation->set_rules('propinsi', 'Propinsi', 'required');
            $this->form_validation->set_rules('kode_pos', 'Kode pos', 'required');
            $this->form_validation->set_rules('no_identitas', 'Nama lengkap', 'required');
            $this->form_validation->set_rules('masa_berlaku_identitas', 'Masa berlaku', 'required|numeric');
            $this->form_validation->set_rules('telp_rumah', 'Telepon (rumah)', 'required|numeric');
            $this->form_validation->set_rules('telp_kantor', 'Telepon (kantor)', 'required|numeric');
            $this->form_validation->set_rules('fax_rumah', 'Fax (rumah)', 'required|numeric');
            $this->form_validation->set_rules('handphone', 'Handphone', 'required|numeric');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
            $this->form_validation->set_rules('nama_perusahaan', 'Nama perusahaan', 'required');
            $this->form_validation->set_rules('jabatan', 'Jabatan', 'required');
            $this->form_validation->set_rules('bidang_usaha', 'Bidang usaha', 'required');

            $this->form_validation->set_rules('form2_1', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_2', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_3', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_4', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_5', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_6', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_6_2', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_7', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_7_2', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_8', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_8_2', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_9', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_10', 'Jabatan', 'required');
            $this->form_validation->set_rules('form2_11', 'Jabatan', 'required');
			
			
            if ($this->form_validation->run()==TRUE){
                //$sql = "INSERT INTO contact_guestbook(nama,email,subject,pesan,dateadded,datemodified) 
                  //      VALUES(?,?,?,?,NOW(),NOW())";
				
                $gender = $this->input->post("gender",TRUE);
                $nama_lengkap = $this->input->post("nama_lengkap",TRUE);
                $usia = $this->input->post("usia",TRUE);
                $kewarganegaraan = $this->input->post("kewarganegaraan",TRUE);
                $alamat = $this->input->post("alamat",TRUE);
                $kota = $this->input->post("kota",TRUE);
                $propinsi = $this->input->post("propinsi",TRUE);
                $kode_pos = $this->input->post("kode_pos",TRUE);
                $no_identitas = $this->input->post("no_identitas",TRUE);
                $masa_berlaku_identitas = $this->input->post("masa_berlaku_identitas",TRUE);
                $telp_rumah = $this->input->post("telp_rumah",TRUE);
                $telp_kantor = $this->input->post("telp_kantor",TRUE);
                $fax_rumah = $this->input->post("fax_rumah",TRUE);
                $handphone = $this->input->post("handphone",TRUE);
                $email = $this->input->post("email",TRUE);
                $nama_perusahaan = $this->input->post("nama_perusahaan",TRUE);
                $jabatan = $this->input->post("jabatan",TRUE);
                $bidang_usaha = $this->input->post("bidang_usaha",TRUE);

                $form2_1 = $this->input->post("form2_1",TRUE);
                $form2_2 = $this->input->post("form2_2",TRUE);
                $form2_3 = $this->input->post("form2_3",TRUE);
                $form2_4 = $this->input->post("form2_4",TRUE);
                $form2_5 = $this->input->post("form2_5",TRUE);
                $form2_6 = $this->input->post("form2_6",TRUE);
                $form2_6_2 = $this->input->post("form2_6_2",TRUE);
                $form2_7 = $this->input->post("form2_7",TRUE);
                $form2_7_2 = $this->input->post("form2_7_2",TRUE);
                $form2_8 = $this->input->post("form2_8",TRUE);
                $form2_8_2 = $this->input->post("form2_8_2",TRUE);
                $form2_9 = $this->input->post("form2_9",TRUE);
                $form2_10 = $this->input->post("form2_10",TRUE);
                $form2_11 = $this->input->post("form2_11",TRUE);

//                echo "1 ".$gender.br(1);
//                echo "2 ".$nama_lengkap.br(1);
//                echo "3 ".$usia.br(1);
//                echo "4 ".$kewarganegaraan.br(1);
//                echo "5 ".$alamat.br(1);
//                echo "6 ".$kota.br(1);
//                echo "7 ".$propinsi.br(1);
//                echo "8 ".$kode_pos.br(1);
//                echo "9 ".$no_identitas.br(1);
//                echo "10 ".$masa_berlaku_identitas.br(1);
//                echo "11 ".$telp_rumah.br(1);
//                echo "12 ".$telp_kantor.br(1);
//                echo "13 ".$fax_rumah.br(1);
//                echo "14 ".$handphone.br(1);
//                echo "15 ".$email.br(1);
//                echo "16 ".$nama_perusahaan.br(1);
//                echo "17 ".$jabatan.br(1);
//                echo "18 ".$bidang_usaha.br(1);
//
//                echo br(3);
//                echo "1 ".$form2_1.br(1);
//                echo "2 ".$form2_2.br(1);
//                echo "3 ".$form2_3.br(1);
//                echo "4 ".$form2_4.br(1);
//                echo "5 ".$form2_5.br(1);
//                echo "6 ".$form2_6.br(1);
//                echo "6_2 ".$form2_6_2.br(1);
//                echo "7 ".$form2_7.br(1);
//                echo "7_2 ".$form2_7_2.br(1);
//                echo "8 ".$form2_8.br(1);
//                echo "8_2 ".$form2_8_2.br(1);
//                echo "9 ".$form2_9.br(1);
//                echo "10 ".$form2_10.br(1);
//                echo "11 ".$form2_11.br(1);
		
                $formatted = "<div style='padding: 5px; background: #EEE; font-size: 18px; font-weight: bold; border-bottom: 1px solid #CCC;'>
                                    Form Data & Informasi 
                                </div>
                                <table width='100%'>
									<tr>
                                        <td width='200px'>Nama Lengkap (Tn./Ny./Nn.)</td>
										<td width='5px'> : </td>
										<td>{$gender} {$nama_lengkap}</td>
                                    </tr>
									<tr>
                                        <td width='200px'>Usia</td>
										<td width='5px'> : </td>
                                        <td>Usia : {$usia} tahun</td>
                                    </tr>
                                    <tr>
                                        <td>Kewarganegaraan</td>
										<td> : </td>
                                        <td>{$kewarganegaraan}</td>
                                    </tr>
                                    <tr>
                                        <td>ALamat Surat Pos </td>
										<td> : </td>
                                        <td>{$alamat}</td>
                                    </tr>
                                    <tr>
                                        <td>Kota :</td>
                                        <td> : </td>
										<td>{$kota}</td>
                                    </tr>
                                    <tr>
                                        <td>Propinsi</td>
										<td> : </td>
                                        <td>{$propinsi}</td>
                                    <tr>
                                        <td>Kode Pos</td>
										<td> : </td>
										<td>{$kode_pos}</td>
                                    </tr>
                                    <tr>
                                        <td>No. Ktp/Pasport :</td>
                                        <td>:</td>
										<td>{$no_identitas} berlaku s/d {$masa_berlaku_identitas}</td>
                                    </tr>
                                    <tr>
                                        <td>Telpon (Rumah)</td>
										<td> : </td>
                                        <td>{$telp_rumah}</td>
                                    </tr>
                                    <tr>
										<td>Telpon (Kantor)</td>
                                        <td> : </td>
                                        <td>{$telp_kantor}</td>
                                    </tr>
                                    
                                    <tr>
                                        <td>Fax (Rumah)</td>
                                        <td> : </td>
										<td>{$fax_rumah}</td>
                                    </tr>
                                    <tr>
										<td>Handphone</td>
                                        <td> : </td>
                                        <td>{$handphone}</td>
                                    </tr>
                                    
                                    <tr>
                                        <td>Email</td>
										<td> : </td>
										<td>{$email}</td>
                                    </tr>
                                    <tr>
                                        <td>Nama Perusahaan</td>
										<td> : </td>
										<td>{$nama_perusahaan}</td>
                                    </tr>
                                    <tr>
                                        <td>Jabatan</td>
										<td> : </td>
										<td>{$jabatan}</td>
                                    </tr>
                                    <tr>
                                        <td>Bidang Usaha</td>
										<td> : </td>
										<td>{$bidang_usaha}</td>
                                    </tr>
                                </table>
                                
                                <br><br>
                           
                                <div style='padding: 5px; background: #EEE; font-size: 18px; font-weight: bold; border-bottom: 1px solid #CCC;'>
                                    Informasi Minta Peluang Usaha Waralaba 
                                </div>
                              
                                <ol style='padding: 20px; margin: 0px;'>
                                    <li>
                                        Peluang Usaha Waralaba <b>ASTON PRINTER</b> yang menjadi minat Anda :
                                        <br>
                                        {$form2_1}
                                    </li>
                                    <li>
                                        Sebutkan nama Kota dan Wilayah yang Anda inginkan untuk usaha Waralaba <b>ASTON PRINTER</b> (<i>Jelaskan secara spesifik lokasi yang Anda inginkan</i>)
                                        <br>
                                        {$form2_2}
                                    </li>
                                    <li>
                                        Apa yang membuat Anda yakin untuk menjalankan usaha <b>ASTON PRINTER</b> dilokasi yang Anda inginkan ? 
                                        <br>
                                        {$form2_3}
                                    </li>
                                    <li> 	
                                        Mohon dijelaskan secara rinci rencana promosi lokal apakah yang akan Anda lakukan jika Anda diberikan hak Waralaba oleh <b>ASTON PRINTER</b>
                                        <br>
                                        {$form2_4}
                                    </li>
                                    <li>
                                        Berapa besar dana yang siap Anda alokasikan untuk rencana promosi lokal setiap bulan untuk toko <b>ASTON PRINTER</b> ? 
                                        <br>
										{$form2_5}
                                    </li>
                                    <li>
                                        Apakah Anda pernah memiliki usaha Waralaba lain sebelumnya ?
                                        <br>
										Jika Ya, sebutkan nama usaha Waralaba tersebut (<i>Wajib dijelaskan dan boleh lebih dari satu</i>) 
                                        <br>
                                        {$form2_6}, {$form2_6_2}
                                    </li>
                                    <li>
                                        Apakah Anda pernah memiliki usaha lain sebelumnya ?
                                        <br>
										Jika Ya, sebutkan nama usaha tersebut (<i>Wajib dijelaskan dan boleh lebih dari satu</i>) 
                                        <br>
                                        {$form2_7}, {$form2_7_2}
                                    </li>
                                    <li>
                                        Darimana Anda mengetahui <b>ASTON PRINTER</b> ?
                                        <br> 
                                        (<i>Mohon sebutkan sumber informasi tersebut dan kapan diperoleh</i>)<br>
                                        {$form2_8}, {$form2_8_2}
                                    </li>
                                    <li>
                                        Apakah Anda telah memiliki calon tenaga kerja yang siap untuk di tempatkan di toko <b>ASTON PRINTER</b> ? 
                                        <br>
										{$form2_9}
                                    </li>
                                    <li>
                                        Apakah Anda telah memahami dengan baik tentang bisnis Waralaba serta resiko usaha Waralaba, khususnya <b>ASTON PRINTER</b> ?
                                        <br>(<i>Mohon dijelaskan secara singkat dan jelas</i>)<br>
                                        {$form2_10}
                                    </li>
                                    <li>
                                        Apakah Anda akan bersedia mengikuti SOP dan seluruh peraturan yang ditetapkan oleh <b>ASTON PRINTER</b> sebagai Franchisor dalam menjalankan usaha Waralaba <b>ASTON PRINTER</b> ?
                                        <br>
										{$form2_5}
										<br> 
                                    </li>
                                </ol> ";
                //echo $formatted;
                $sql = "INSERT INTO franchaise_detail(nama,alamat_pos,kota,propinsi,jabatan,detail_all,status,dateadded) VALUES(?,?,?,?,?,?)";
                $simpan = $this->db->query($sql,array($nama_lengkap,$alamat,$kota,$propinsi,$jabatan,$formatted,'UNREAD',NOW()));
                
                $this->session->set_flashdata("message_contact","Terima kasih {$gender} {$nama_lengkap} telah mengisi form survey franchaise Aston Printer Center");
                //$data["message_contact"] = "Terima kasih {$nama} telah mengisi form kontak kami";
                redirect('franchise');
            }else{
            
                $alias = $this->uri->segment(1);
                $data['konten']=$this->m_profile_content->get_konten($alias);
                $data["message_contact"] = $this->session->flashdata("message_contact");
                $this->load->view('front/top',$data);
                $this->load->view('front/v_franchise',$data);
                $this->load->view('front/bottom',$data);
            }
	}
        
        
}
?>
