<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class News extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('news_model');
        $this->load->model('model_app');
        $this->load->library('ajax_pagination');
        $this->perPage = 3;
    }

    private $view = "frontend/news";

    public function index() {

        $id = $this->input->get('id');
        $id2['id'] = $id;
        $data = array();

        //total rows count
        $totalRec = count($this->news_model->getRows());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'news/ajaxPaginationData';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data = array(
            'title' => "Amazink News",
            'meta_desc' => "Informasi dan tips seputar AMAZiNK dan seputar dunia printer",
            'met_key' => "Informasi dan tips seputar AMAZiNK dan seputar dunia printer",
            'home' => "transparent",
            'posts' => $this->news_model->getRows(array('limit' => $this->perPage)),
        );
        //$data['posts'] = $this->post->getRows(array('limit'=>$this->perPage));
        //load the view
        renderFront("$this->view/v_news_index_new", $data);
    }

    function kategori() {
        $id = $this->input->get('id');
        $id2['id'] = $id;
        $data = array();

        //total rows count
        $totalRec = count($this->news_model->getRows());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'news/ajaxPaginationData';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data = array(
            'title' => "Amazink News",
            'meta_desc' => "Informasi dan tips seputar AMAZiNK dan seputar dunia printer",
            'met_key' => "Informasi dan tips seputar AMAZiNK dan seputar dunia printer",
            'home' => "transparent",
            'posts' => $this->news_model->getRows(array('limit' => $this->perPage)),
        );
        //$data['posts'] = $this->post->getRows(array('limit'=>$this->perPage));
        //load the view
        renderFront("$this->view/v_news_index_new", $data);
    }

    function ajaxPaginationData() {
        $page = $this->input->post('page');
        if (!$page) {
            $offset = 0;
        } else {
            $offset = $page;
        }

        //total rows count
        $totalRec = count($this->news_model->getRows());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'news/ajaxPaginationData';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data['posts'] = $this->news_model->getRows(array('start' => $offset, 'limit' => $this->perPage));

        //load the view
        $this->load->view("$this->view/ajax-pagination-data", $data, false);
    }

    function get_news($offset) {
        $data = array(
            'num_messages' => $this->news_model->num_messages(),
            'kategoriProduk' => $this->news_model->get_messages($offset),
        );
        $this->load->view("$this->view/more_news", $data);
    }

    function read() {
        $key['id'] = $this->uri->segment(3);
        $fav['fav'] = 1;
        $getKonten = $this->model_app->getSelectedData('news', $key);
        foreach ($getKonten->result() as $gtk) {
            $title = $gtk->title;
            $desc = $gtk->meta_description;
            $keyword = $gtk->meta_keyword;
            $picture = $gtk->picture;
            $content = $gtk->content;
        }
        $data = array(
            'id' => $this->uri->segment(3),
            'title' => $title,
            'meta_desc' => $desc,
            'met_key' => $keyword,
            'picture' => $picture,
            'content' => $content,
            'home' => "transparent",
        );
        renderFront("$this->view/v_artikel_read", $data);
    }

    function insert_rows() {
        $i = 0;
        while ($i < 50) {
            $i++;
            $data = array('username' => 'user', 'message' => 'message ' . $i);
            $this->db->insert('twitter_messages', $data);
            echo $i . '<br />';
        }
    }

    function get_messages($offset) {
        $data = array(
            'num_messages' => $this->news_model->num_messages(),
            'latest_messages' => $this->news_model->get_messages($offset),
        );
        $this->load->view("$this->view/v_news_index", $data);
    }

}

/* End of file news.php */
/* Location: ./application/controllers/news.php */