<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Newsroom extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    function __construct() {
        parent::__construct();
        $this->load->model(array("M_products", "m_products", "m_profile_content", "m_newsroom"));
    }

    public function index() {
        $data['title'] = "Newsroom";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $data['judul'] = "Recent News";

        $alias = $this->uri->segment(1);
        $data['konten'] = $this->m_profile_content->get_konten($alias);

        $data["products_menu"] = $this->m_products->get_available_brands();
        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();

        $this->load->library('pagination');

        $data['list_newsroom'] = $this->m_newsroom->get_list_newsroom(intval($this->uri->segment(3)), 3);
        $config['base_url'] = base_url("newsroom/page/");
        $config['total_rows'] = $this->m_newsroom->get_available_newsroom_count();
        $config['per_page'] = 3;
        $config['uri_segment'] = 3;
        $this->pagination->initialize($config);
        $data["pager"] = $this->pagination->create_links();
        $data['home'] = "";

        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_newsroom', $data);
        $this->load->view('frontamazink/footer.php', $data);
    }

    function page() {
        $this->index();
    }

    function read() {
        $id_newsroom = intval($this->uri->segment(3));
        $url_title = $this->uri->segment(4);
        $data['title'] = "Newsroom";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $data['judul'] = "Recent News";

        $alias = $this->uri->segment(1);
        $data['konten'] = $this->m_profile_content->get_konten($alias);
        $data['list_newsroom'] = $this->m_newsroom->get_list_newsroom();
        $data['newsroom'] = $this->m_newsroom->get_newsroom_by_id($id_newsroom, $url_title);
        $data["products_menu"] = $this->m_products->get_available_brands();

        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();
        $data['latest_news_thumb'] = $this->m_newsroom->get_latest_news_thumb($id_newsroom);
        $data['home'] = "";

        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_detail_newsroom', $data);
        $this->load->view('frontamazink/footer.php', $data);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */