<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Store extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    function __construct() {
        parent::__construct();
        $this->load->model(array('m_profile_content', 'm_newsroom', 'm_cart'));
        $this->load->model("M_products", "m_products");
        date_default_timezone_set('Asia/Jakarta');
    }

//    public function index() {
//        $data['title'] = "Products";
//        $data['header_aston'] = img('assets/images/header_aston.png');
//
//        $data['header_link_fb'] = img('assets/images/fb_gray.png');
//        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
//        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
//        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
//
//        $data['judul'] = "Products";
//
//        $data['slider'] = $this->m_profile_content->get_slider_produk();
//        $alias = $this->uri->segment(1);
//        $data['konten'] = $this->m_profile_content->get_konten("products");
//        $data["products_menu"] = $this->m_products->get_available_brands();
//        $data["products_content"] = $this->m_products->get_available_brand_and_category();
//        $data['link_image_brands'] = $this->m_products->get_image_brands();
//        $data['latest_news'] = $this->m_newsroom->get_latest_news();
//
//        $data['home']="";
//
//        $this->load->view('frontamazink/header.php', $data);
//        $this->load->view('frontamazink/v_menu.php', $data);
//        $this->load->view('frontamazink/v_store', $data);
//        $this->load->view('frontamazink/footer.php', $data);
//        
//        
//    }
    
    
    public function index() {
        $data['title'] = "Aston Printer Center | Outlets";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');

        $data['konten'] = $this->m_profile_content->get_konten("outlets");
        $data["products_menu"] = $this->m_products->get_available_brands();
        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();
        $data["message_reseller"] = $this->session->flashdata("message_reseller");
        $data['home'] = "";

        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_support_store', $data);
        $this->load->view('frontamazink/footer.php', $data);
    }


    public function brand() {
        $this->load->library('pagination');
        $data['title'] = "Aston Printer Center | Product";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
        $data['water'] = img('assets/images/water.png', array('width' => '50px', 'height' => '50px'));
        $data['water'] = "<img src='" . base_url() . "assets/images/water.png' width='20px' height='20px'>";
        $data['judul'] = "Products";

        $data['slider'] = $this->m_profile_content->get_slider_produk();
        $data["products_menu"] = $this->m_products->get_available_brands();
        $id_brand = $this->uri->segment(3);
        $nama_brand = $this->uri->segment(4);
        $data['brand_by_id'] = $this->m_products->get_brand_by_id($id_brand);
        $data['subbrand_by_brand'] = $this->m_products->get_subbrand_by_brand($id_brand);
        if (($this->uri->segment(5) == TRUE) && (intval($this->uri->segment(5)) == TRUE)) {
            $id_sub_brand = $this->uri->segment(5);
            $nama_sub_brand = $this->uri->segment(6);
            $data['list_product_detail'] = $this->m_products->get_list_product_detail($id_brand, $id_sub_brand, intval($this->uri->segment(8)), 6);

            $config['base_url'] = base_url("products/brand/" . $id_brand . "/" . $nama_brand . "/" . $id_sub_brand . "/" . $nama_sub_brand . "/page/");
            $config['total_rows'] = $this->m_products->get_available_product_detail_count($id_brand, $id_sub_brand);
            $config['per_page'] = 6;
            $config['uri_segment'] = 8;
            $this->pagination->initialize($config);
            $data["pager"] = $this->pagination->create_links();
        } else {
            $data['list_product_detail_by_brand'] = $this->m_products->get_list_product_detail_by_brand($id_brand, intval($this->uri->segment(6)), 6);

            $config['base_url'] = base_url("products/brand/" . $id_brand . "/" . $nama_brand . "/page/");
            $config['total_rows'] = $this->m_products->get_available_product_by_brand_count($id_brand);
            $config['per_page'] = 6;
            $config['uri_segment'] = 6;
            $this->pagination->initialize($config);
            $data["pager"] = $this->pagination->create_links();
        }
        $data['link_image_brands'] = $this->m_products->get_image_brands();
        $data['latest_news'] = $this->m_newsroom->get_latest_news();
        $data['home']="";
        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_product_brand', $data);
        $this->load->view('frontamazink/footer.php', $data);
        
    }

    function page() {
        $this->index();
    }

    function detail($id_product) {
        $data['title'] = "Aston Printer Center | Product Detail";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
        $data['water'] = img('assets/images/water.png', array('width' => '50px', 'height' => '50px'));
        $data['water'] = "<img src='" . base_url() . "assets/images/water.png' width='20px' height='20px'>";
        $data['judul'] = "Product Detail";

        $data['product'] = $this->m_products->get_detail_product($id_product);
        if ($data['product']) {
            $data['slider'] = $this->m_profile_content->get_slider_produk();
            $data["products_menu"] = $this->m_products->get_available_brands();
            $id_brand = $data['product']->product_brand_fk;
            $nama_brand = $data['product']->product_sub_brand_fk;
            $data['brand_by_id'] = $this->m_products->get_brand_by_id($id_brand);
            $data['subbrand_by_brand'] = $this->m_products->get_subbrand_by_brand($id_brand);
        }
        $this->load->view('frontamazink/v_detail_produk', $data);
    }
    
    function buy($id_product){
        if ($this->session->userdata('session_id')) {
            $session_id = $this->session->userdata('session_id');
        } else {
            $this->session->set_userdata('aa', 'aa');
            $session_id = $this->session->userdata('session_id');
        }
        
        //cek_produk_dalam_temp_cart
        $cek = $this->m_cart->cek_product_temp_cart($session_id,$id_product);
        if($cek > 0){
            $update_cart = $this->m_cart->update_temp_cart($session_id,$id_product);
        }else{
            $tanggal = date('Y-m-d h:i:s');
            $data['session_id'] = $session_id;
            $jumlah = 1;

            $data_cart = array(
                'sessionid' => $session_id,
                'tanggal' => $tanggal,
                'product_detailfk' => $id_product,
                'jumlah' => $jumlah
            );

            $this->m_cart->simpan_temp_cart($data_cart);
        }
        redirect('cart/view/'.$session_id);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */