<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Toko extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model("model_app");
        $this->load->helper('ongkir');
        $this->load->model('news_model');
        $this->load->model('toko_model');
        $this->load->library('ajax_pagination');
        $this->perPage = 9;
    }

    private $view = "frontend/shop";

    public function index() {
        $featuredproduct = "select * from product where featured='Yes'and category_id != 2 limit 3";
        $key['featured'] = "Yes";
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            'produk' => $this->model_app->getSelectedData('product', $key)->result(),
            'kategori' => $this->model_app->getAllData('product_category')->result(),
            'feature' => $this->db->query($featuredproduct)->result(),
            "slider" => $this->model_app->getAllData_order_by('slider_toko', 'no_urut', 'asc')
        );
        renderFront("$this->view/indextoko", $data);
    }

    function produk() {
        $id = $this->uri->segment(3);
        $featuredproduct = "select * from product where featured='Yes'and category_id != 2 order by RAND() limit 4";
        $product = "select a.*, b.kategori_utama from product a left join kategori_utama b on a.category_id=b.id where a.id=$id";
        $productImage = "select * from product_image where product_id=$id";
        $tagproduct = "select a.*, b.name from tag_product a left join product_category b on a.kategori_id=b.id where a.product_id=$id";
        $getPP = $this->db->query($product)->result();
        foreach ($getPP as $gp) {
            $title = $gp->product_name;
            $desc = $gp->description;
        }
        $data = array(
            'home' => "",
            "title" => $title,
            'meta_desc' => $desc,
            'met_key' => $desc,
            'produk' => $this->db->query($product)->result(),
            'produkImage' => $this->db->query($productImage)->result(),
            'kategori' => $this->model_app->getAllData('product_category')->result(),
            'feature' => $this->db->query($featuredproduct)->result(),
            'tagproduk' => $this->db->query($tagproduct)->result(),
        );

        renderFront("$this->view/detailproduk", $data);
    }
    
    function produkKategori(){
        $id = $this->input->get('id');
        echo $id;
    }

    function kategori() {
        $id = $this->input->get('id', TRUE);

        $ses_id = array(
            'catid' => $id
        );
        $this->session->set_userdata($ses_id);
        $mys = array(
            'kategori_id' => $id,
        );
        $this->session->set_userdata($mys);
        $categoryproduct = "select * from product where category_id=$id";
        $featuredproduct = "select * from product where featured='Yes'and category_id != 2 order by RAND() limit 4";
        $id2['id'] = $id;
        $data = array();

        //total rows count
        $totalRec = count($this->toko_model->getRows());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'toko/ajaxPaginationData';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            'feature' => $this->db->query($featuredproduct)->result(),
            'd_kategori' => $this->model_app->getSelectedData('kategori_utama', $id2)->result(),
            'kategori' => $this->model_app->getAllData('product_category')->result(),
            'posts' => $this->toko_model->getRows(array('limit' => $this->perPage)),
        );
        //$data['posts'] = $this->post->getRows(array('limit'=>$this->perPage));
        //load the view
        renderFront("$this->view/kategoriProduk", $data);
    }

    function ajaxPaginationData() {
        $page = $this->input->post('page');
        if (!$page) {
            $offset = 0;
        } else {
            $offset = $page;
        }

        //total rows count
        $totalRec = count($this->toko_model->getRows());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'toko/ajaxPaginationData';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data['posts'] = $this->toko_model->getRows(array('start' => $offset, 'limit' => $this->perPage));

        //load the view
        $this->load->view("$this->view/ajax-pagination-data", $data, false);
    }

    function cari_produk() {
        $keyword = $this->input->post('keyword');
        $myso = array(
            'keyword_sc' => $keyword,
        );
        $this->session->set_userdata($myso);
        $featuredproduct = "select * from product where featured='Yes' and category_id != 2 order by RAND() limit 4";

        //total rows count
        $totalRec = count($this->toko_model->getRowsSearch());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'toko/ajaxPagingSearch';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            'posts' => $this->toko_model->getRowsSearch(array('limit' => $this->perPage)),
            'feature' => $this->db->query($featuredproduct)->result(),
            'kategori' => $this->model_app->getAllData('product_category')->result(),
                //'kategoriProduk' => $this->db->query($categoryproduct)->result(),
        );
        renderFront("$this->view/pencarian", $data);
    }

    function ajaxPagingSearch() {
        $page = $this->input->post('page');
        if (!$page) {
            $offset = 0;
        } else {
            $offset = $page;
        }

        //total rows count
        $totalRec = count($this->toko_model->getRowsSearch());

        //pagination configuration
        $config['target'] = '#main_content';
        $config['base_url'] = base_url() . 'toko/ajaxPagingSearch';
        $config['total_rows'] = $totalRec;
        $config['per_page'] = $this->perPage;
        $this->ajax_pagination->initialize($config);

        //get the posts data
        $data['posts'] = $this->toko_model->getRowsSearch(array('start' => $offset, 'limit' => $this->perPage));

        //load the view
        $this->load->view("$this->view/ajax-pagination-data", $data, false);
    }

    function get_more_search($offset) {
        $data = array(
            'num_messages' => $this->news_model->num_search_produk(),
            'kategoriProduk' => $this->news_model->get_search_produk($offset),
        );
        $this->load->view("$this->view/more_produk", $data);
    }

    function get_produk($offset) {
        $data = array(
            'num_messages' => $this->news_model->num_produk(),
            'kategoriProduk' => $this->news_model->get_produk($offset),
        );
        $this->load->view("$this->view/more_produk", $data);
    }

    function addtocart() {
        $id_product = $this->input->post('id_product');
        $nama = $this->input->post('nama_produk');
        $harga = $this->input->post('harga');
        $cost = $this->input->post('cost');
        $stock = $this->input->post('stock');
        $diskon = $this->input->post('diskon');
        $qty = $this->input->post('qty');
        $foto = $this->input->post('foto');
        $berat = $this->input->post('berat');
        $data = array(
            'id' => $id_product,
            'name' => $nama,
            'qty' => $qty,
            'price' => $harga,
            'cost' => $cost,
            'diskon' => $diskon,
            'total' => $qty * $harga,
            'foto' => $foto,
            'stock' => $stock,
            'berat' => $berat
        );
        $this->cart->insert($data);
        redirect('toko/cart');
    }

    function cartO() {
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            "title" => "toko amazinkprint",
        );
        renderFront("$this->view/checkout", $data);
    }

    function cart() {
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            "title" => "toko amazinkprint",
        );
        renderFront("$this->view/new_cekout", $data);
    }

    function deleteProduct() {
        $id = $this->uri->segment(3);
        $data = array(
            'rowid' => $id,
            'qty' => 0
        );
        $this->cart->update($data);
        redirect('toko/cart');
    }

    function to_cekout2() {
        $nm_pembeli = $this->input->post('nm_pembeli');
        $email = $this->input->post('email');
        $alamat_pembeli = $this->input->post('alamat_pembeli');
        $no_telp_pembeli = $this->input->post('no_telp_pembeli');
        $nm_penerima = $this->input->post('nm_penerima');
        $no_telp_penerima = $this->input->post('no_telp_penerima');
        $alamat_penerima = $this->input->post('alamat_penerima');
        $pembayaran_bank = $this->input->post('pembayaran_bank');
        $data = array(
            'nm_pembeli' => $nm_pembeli,
            "email" => $email,
            "alamat_pembeli" => $alamat_pembeli,
            "no_telp_pembeli" => $no_telp_pembeli,
            "nm_penerima" => $nm_penerima,
            "no_telp_penerima" => $no_telp_penerima,
            "alamat_penerima" => $alamat_penerima,
            "pembayaran_bank" => $pembayaran_bank
        );
        $this->db->insert("tmp_head_pembelian", $data);
        $id_tmp = $this->db->insert_id();
        $getid['id_tmp'] = $id_tmp;
        $this->session->set_userdata($getid);
        redirect("toko/go_cekout2");
    }

    function go_cekout2() {
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            "title" => "toko amazinkprint",
        );
        renderFront("$this->view/new_cekout2", $data);
    }

    function destroy() {
        $this->cart->destroy();
        redirect('toko/cart');
    }

    function myOngkir() {
        $citi2 = $this->input->post('city_destination');
        $weig = $this->input->post('berat');
        $kurir = $this->input->post('kurir');
        $data = array(
            "query" => json_decode(GetCost(386, $citi2, $weig * 1000, $kurir), TRUE)
        );
        $this->load->view("$this->view/hasil_ongkir", $data);
    }

    function myOngkir_cek() {
        $citi2 = $this->input->post('city_destination');
        $weig = $this->input->post('berat');
        $kurir = $this->input->post('kurir');
        $data = array(
            "query" => json_decode(GetCost(386, 37, 3, 'pos'), TRUE)
        );
        $this->load->view("$this->view/hasil_ongkir", $data);
    }

    function simpanData() {
        $id_pembeli = $this->session->userdata('id_tmp');
        $getTmp['id'] = $id_pembeli;
        $temp_table = $this->db->get_where('tmp_head_pembelian', $getTmp)->result();
        $sub_total = $this->input->post('sub_total');
        $shipping = $this->input->post('shipping_val');
        $jml_bayar = $this->input->post('total_order_val');
        $jml_item = $this->input->post('t_qty');
        $berat = $this->input->post('t_berat');
        foreach ($temp_table as $tb) {
            $nm_pembeli = $tb->nm_pembeli;
            $email = $tb->email;
            $no_telp_pembeli = $tb->no_telp_pembeli;
            $alamat_pembeli = $tb->alamat_pembeli;
            $nm_penerima = $tb->nm_penerima;
            $no_telp_penerima = $tb->no_telp_penerima;
            $alamat_penerima = $tb->alamat_penerima;
            $pembayaran_bank = $tb->pembayaran_bank;
        }
        $this->load->helper('string');
        $id_trx = random_string('alnum', 5);
        $data = array(
            'id' => $id_trx,
            'tanggal' => date('Y-m-d'),
            'nm_pembeli' => $nm_pembeli,
            'email' => $email,
            'no_telp_pembeli' => $no_telp_pembeli,
            'alamat_pembeli' => $alamat_pembeli,
            'nm_penerima' => $nm_penerima,
            'no_telp_penerima' => $no_telp_penerima,
            'alamat_penerima' => $alamat_penerima,
            'pembayaran_bank' => $pembayaran_bank,
            't_berat' => $berat,
            'sub_total' => $sub_total,
            'shipment' => $shipping,
            'jml_bayar' => $jml_bayar,
            'jml_item' => $jml_item,
        );
        
        foreach ($this->cart->contents() as $items) {
            $d_detail['pembelian_id'] = $id_trx;
            $d_detail['tanggal'] = date('Y-m-d');
            $d_detail['product_id'] = $items['id'];
            $d_detail['qty'] = $items['qty'];
            $d_detail['harga'] = $items['price'];
            $d_detail['berat'] = $items['berat'];
            $d_detail['sub_total'] = $items['qty'] * $items['price'];
            $this->model_app->insertData("detail_belanja", $d_detail);
            $d_u['stok'] = $this->model_app->getKurangStok($items['id'],  $items['qty']);
        }

        $this->db->insert('head_pembelian', $data);
        $this->session->set_flashdata('konfirmasi', 'Terima kasih sudah berbelanja di toko online Amazink. '
                . 'Segera konfirmasikan transaksi Anda jika sudah melakukan pembayaran untuk produk yang Anda '
                . 'order melalui SMS (+62 82221333183) atau email (marketing@amazinkprint.com) yang tercantum di "Cara Belanja"');
        $this->cart->destroy();
        redirect('toko/cart');
    }
    
    function terimaKasih(){
        $data = array(
            'title' => "Toko Online Amazink",
            'meta_desc' => "Toko Online Amazink",
            'met_key' => "Toko Online Amazink",
            'home' => "",
            "title" => "toko amazinkprint",
        );
        $this->session->set_flashdata('konfirmasi', 'Terima kasih sudah berbelanja di toko online Amazink. '
                . 'Segera konfirmasikan transaksi Anda jika sudah melakukan pembayaran untuk produk yang Anda '
                . 'order melalui SMS (+62 82221333183) atau email (marketing@amazinkprint.com) yang tercantum di "Cara Belanja"');
        renderFront("$this->view/terimakasih", $data);
    }

}

/* End of file toko.php */
/* Location: ./application/controllers/toko.php */