<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Transaksi extends CI_Controller {

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     * 	- or -  
     * 		http://example.com/index.php/welcome/index
     * 	- or -
     * Since this controller is set as the default controller in 
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    function __construct() {
        parent::__construct();
        $this->load->model(array('m_profile_content', 'm_newsroom', 'm_products'));
        $this->load->model("M_cart", "m_cart");
        date_default_timezone_set('Asia/Jakarta');
    }

    function view() {
        $data['title'] = "Aston Printer Center | Transaksi";
        $data['header_aston'] = img('assets/images/header_aston.png');

        $data['header_link_fb'] = img('assets/images/fb_gray.png');
        $data['header_link_twitter'] = img('assets/images/twitter_gray.png');
        $data['header_link_gplus'] = img('assets/images/gplus_gray.png');
        $data['header_link_blogger'] = img('assets/images/blogger_gray.png');
        $data['water'] = img('assets/images/water.png', array('width' => '50px', 'height' => '50px'));
        $data['water'] = "<img src='" . base_url() . "assets/images/water.png' width='20px' height='20px'>";
        $data['judul'] = "Cart";
        $data['slider'] = $this->m_profile_content->get_slider_produk();
        $data["products_menu"] = $this->m_products->get_available_brands();
        
        if($this->uri->segment(3,0)){
            $notrans = $this->uri->segment(3);
        }else if(isset($_POST['notrans'])){
            $notrans = $_POST['notrans'];
        }else{
            $notrans = FALSE;
        }
        if($notrans != FALSE){
            $data['transaksi'] = $this->m_cart->get_transaksi_by_id($notrans);
            $transaksi_pk = $data['transaksi']->pk;
            $data['detail_transaksi'] = $this->m_cart->get_detail_transaksi_by_trans_pk($transaksi_pk);
        }
        $data['home'] = "";
        
        $this->load->view('frontamazink/header.php', $data);
        $this->load->view('frontamazink/v_menu.php', $data);
        $this->load->view('frontamazink/v_transaksi', $data);
        $this->load->view('frontamazink/footer.php', $data);
        
    }
}