<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Video extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		$this->load->model(array("M_products", "m_products", "m_profile_content", "m_newsroom", "m_video"));
		
		$data['title']="Aston Printer Center";
		$data['header_aston']=img('assets/images/header_aston.png');
		$data['header_link_fb']=img('assets/images/fb_gray.png');
		$data['header_link_twitter']=img('assets/images/twitter_gray.png');
		$data['header_link_gplus']=img('assets/images/gplus_gray.png');
		$data['header_link_blogger']=img('assets/images/blogger_gray.png');
		
		$data['slider'] = $this->m_profile_content->get_slider();
		
			$this->load->library('pagination');
			$data['list_video'] = $this->m_video->get_list_video(intval($this->uri->segment(3)),2);
			$config['base_url'] = base_url("video/page/");
			$config['total_rows'] = $this->m_video->get_available_video_count();;
			$config['per_page'] = 2;
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config);
			$data["pager"] = $this->pagination->create_links();
		
		$data['link_video']=img('assets/images/link_video.png');
		
		$data['link_image_brands'] = $this->m_products->get_image_brands();
		$data['latest_news'] = $this->m_newsroom->get_latest_news();                
		$data["products_menu"] = $this->m_products->get_available_brands();
		
		$this->load->view('front/top',$data);
		$this->load->view('front/v_video',$data);
		$this->load->view('front/bottom',$data);
	}
	
		function page(){
            $this->index();
        }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */