<?php

class Model_app extends CI_Model {

    public function getAllData($table) {
        return $this->db->get($table);
    }

    public function getAllData_order_by($table, $order_by, $ad) {
        $this->db->order_by($order_by, $ad);
        return $this->db->get($table);
    }

    public function getAllDataLimited($table, $limit, $offset) {
        return $this->db->get($table, $limit, $offset);
    }

    function getAllLimited($table, $limit, $order_by, $ad) {
        return $this->db->get($table, $limit, $order_by, $ad);
    }

    public function getSelectedDataLimited($table, $data, $limit, $offset) {
        return $this->db->get_where($table, $data, $limit, $offset);
    }

    public function getSelectedData($table, $data) {
        return $this->db->get_where($table, $data);
    }

    function updateData($table, $data, $field_key) {
        $this->db->update($table, $data, $field_key);
    }

    function deleteData($table, $data) {
        $this->db->delete($table, $data);
    }

    function insertData($table, $data) {
        $this->db->insert($table, $data);
    }

    function manualQuery($q) {
        return $this->db->query($q);
    }

    function getIDtrx() {
        $kode_trx = "";
        $q = $this->db->query("SELECT max(id_transaksi) as no_akhir FROM transaction_head");
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $no = $row->no_akhir;
                $no_akhir = (int) substr($no, 5, 4);

                $no_akhir++;
            }

            //membuat format kode beli
            $kode_trx_akhir = 'TRX-' . sprintf("%04s", $no_akhir);
            $kode_trx = $kode_trx_akhir;
        } else {
            $kode_trx = "TRX-0001";
        }
        return $kode_trx;
    }

    function getKurangStok($id, $qty) {
        $key['id'] = $id;
        $getProduk = $this->db->get_where('product', $key);
        if($getProduk->num_rows() > 0){
            foreach ($getProduk->result() as $gpd){
                $stock = $gpd->stock;
            }
            $kurang = $stock - $qty;
            $datau = array(
                'stock' => $kurang,
            );
            $this->db->update('product', $datau, $key);
        }else{
            echo "SORRY YOUR PRODUCT NOT FOUND...!!";
        }
    }

}

?>
