<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class News_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function getRows($params = array()) {

        $this->db->select('*');
        $this->db->from('news');
        $this->db->order_by('id', 'desc');

        if (array_key_exists("start", $params) && array_key_exists("limit", $params)) {
            $this->db->limit($params['limit'], $params['start']);
        } elseif (!array_key_exists("start", $params) && array_key_exists("limit", $params)) {
            $this->db->limit($params['limit']);
        }

        $query = $this->db->get();

        return ($query->num_rows() > 0) ? $query->result() : FALSE;
    }

    function get_messages($offset = 0) {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('news', 3, $offset);
        return $query->result();
    }

    function num_messages() {
        $query = $this->db->count_all_results('news');
        return $query;
    }

    function get_produk($offset = 0) {
        $ses_kt = $this->session->userdata('kategori_id');
        if ($ses_kt == "") {
            $id['category_id'] = $this->uri->segment(3);
        } else {
            $id['category_id'] = $ses_kt;
        }
        $query = $this->db->get_where('product', $id, 6, $offset);
        return $query->result();
    }

    function num_produk() {
        $id = $this->uri->segment(3);
        $product = "SELECT COUNT(*) AS `numrows` FROM (`product`) where category_id=$id";
        $query = $this->db->query($product);
        ;
        foreach ($query->result() as $qst) {
            $jm = $qst->numrows;
        }
        return $jm;
    }

    function get_search_produk($offset = 0) {
        $ses_kt = $this->session->userdata('keyword_sc');
        if ($ses_kt == "") {
            $keyword_sc = $this->input->post('keyword');
        } else {
            $keyword_sc = $ses_kt;
        }
        $this->db->order_by('product_name', 'asc');

        $ids = explode(' ', $keyword_sc);
        foreach ($ids as $is) {
            $this->db->like('product_name', $is);
        }
        $query = $this->db->get('product', 6, $offset);
        return $query->result();
    }

    function num_search_produk() {
        $keyword_sc = $this->input->post('keyword');
        $product = "SELECT COUNT(*) AS `numrows` FROM (`product`) where product_name like '%$keyword_sc%'";
        $query = $this->db->query($product);
        foreach ($query->result() as $qst) {
            $jm = $qst->numrows;
        }
        return $jm;
    }

}

/* End of file news_model.php */
/* Location: ./application/models/news_model.php */