<?php
foreach ($produk as $pro) {
    $id = $pro->id;
    $nama = $pro->product_name;
    $deskripsi = $pro->description;
    $image = $pro->product_image;
    $kategorin = $pro->kategori_utama;
    $cost = $pro->cost;
    $harga = $pro->price;
    $diskon = $pro->discount;
    $new = $pro->new;
    $stok = $pro->stock;
    $berat = $pro->weight;
    $disable = "";
    if ($stok == "") {
        $stok = 0;
        $disable = "disabled";
    }
}
?>
<section class="page-section pb-10">
    <div class="container relative">

        <!-- Product Content -->
        <div class="row mb-20 mb-xs-30">

            <!-- Product Images -->
            <div class="col-md-4 mb-md-30">

                <div class="post-prev-img">
                    <a href="<?= base_url() ?>assets/product_image/<?= $image ?>" class="lightbox-gallery-3 mfp-image">
                        <img src="<?= base_url() ?>assets/product_image/<?= $image ?>" alt="<?= $image ?>" /></a>
                    </a>
                    <div class="intro-label">
                        <span class="label label-danger bg-red">Sale</span>
                    </div>
                </div>

                <div class="row">
                    <?php
                    foreach ($produkImage as $proim) {
                        ?>
                        <div class="col-xs-3 post-prev-img">
                            <a href="<?= base_url() ?>assets/product_image/<?= $proim->product_image ?>" class="lightbox-gallery-3 mfp-image">
                                <img src="<?= base_url() ?>assets/product_image/<?= $proim->product_image ?>" alt="" />
                            </a>
                        </div>
                    <?php }
                    ?>

                </div>

            </div>
            <!-- End Product Images -->

            <!-- Product Description -->
            <div class="col-sm-8 col-md-5 mb-xs-40">

                <h3 class="mt-0"><?= $nama ?></h3>

                <hr class="mt-0 mb-30"/>

                <div class="row">
                    <div class="col-xs-6 lead mt-0 mb-20">
                        
                        <?php
                        if (($diskon == 0) || ($diskon == '')) {
                            $harga_produk = $harga;
                            echo "<strong> Rp. " . number_format($harga) . "</strong>";
                        } else {
                            $pot = ($diskon / 100) * $harga;
                            $harganya = $harga - $pot;
                            $harga_produk = $harganya;
                            echo "<del class='section-text'>Rp. " . number_format($harga) . "</del>&nbsp;";
                            echo "<strong>Rp. " . number_format($harganya) . "</strong>";
                        }
                        ?>

                    </div>

                </div>
                
                <hr class="mt-0 mb-30"/> 

                <div class="section-text mb-30">
                    <?= $deskripsi ?>
                </div>

                <hr class="mt-0 mb-30"/> 

                <div class="mb-30">
                    <form method="post" action="<?= base_url() ?>toko/addtocart" class="form">
                        <input type="hidden" name="id_product" value="<?= $id ?>">
                        <input type="hidden" name="nama_produk" value="<?= $nama ?>">

                        <input type="hidden" name="cost" value="<?= $cost ?>">
                        <input type="hidden" name="diskon" value="<?= $diskon ?>">
                        <input type="hidden" name="harga_asli" value="<?= $harga ?>">

                        <input type="hidden" name="stock" value="<?= $stok ?>">
                        <input type="hidden" name="berat" value="<?= $berat ?>">
                        <input type="hidden" name="harga" value="<?= $harga_produk ?>">
                        <input type="hidden" name="foto" value="<?= $image ?>">
                        <input type="number" <?= $disable ?> name="qty" class="input-lg round" min="1" max="<?= $stok ?>" value="1" />
                        <button type="submit" <?= $disable ?> class="btn btn-mod btn-large btn-round">Add to Cart</button>
                    </form>
                </div>

                <hr class="mt-0 mb-30"/> 

                <div class="section-text small">
                    <div>Berat: <a href=""> <?= $berat ?></a></div>
                    <div>Category: <a href=""> <?= $kategorin ?></a></div>
                    <div>Tags: <?php
                        foreach ($tagproduk as $tgpr) {
                            ?>
                            <a href="<?= base_url() ?>toko/tags/<?= $tgpr->id ?>/<?= url_title($tgpr->name) ?>.html"><?= $tgpr->name ?></a>, 
                        <?php }
                        ?>

                    </div>
                </div>

            </div>
            <!-- End Product Description -->

            <!-- Features -->
            <div class="col-sm-4 col-md-3 mb-xs-40">

                <!-- Features Item -->
                <div class="alt-service-wrap">
                    <div class="alt-service-item">
                        <div class="alt-service-icon">
                            <i class="fa fa-paper-plane-o"></i>
                        </div>
                        <h3 class="alt-services-title font-alt">Pengiriman</h3>
                        Produk AMAZiNK dikirimkan dari Salatiga.Pengiriman Barang Menggunakan Jasa JNE.
                    </div>
                </div>
                <!-- End Features Item -->

                <!-- Features Item -->
                <div class="alt-service-wrap">
                    <div class="alt-service-item">
                        <div class="alt-service-icon">
                            <i class="fa fa-clock-o"></i>
                        </div>
                        <h3 class="alt-services-title font-alt">Pemesanan</h3>
                        Pesanan dikirimkan paling lambat 2x24 jam
                        setelah Anda melakukan transfer pembayaran
                        dan mengkonfirmasi melalui email atau SMS
                    </div>
                </div>
                <!-- End Features Item -->

                <!-- Features Item -->
                <div class="alt-service-wrap">
                    <div class="alt-service-item">
                        <div class="alt-service-icon">
                            <i class="fa fa-money"></i>
                        </div>
                        <h3 class="alt-services-title font-alt">Pembayaran</h3>
                        Nomor rekening Bank AMAZiNK<br/>
                        Bank BCA : 0131117000<br/>
                        Atas nama Amazink Karya Indonesia <br/>
                        Bank Mandiri : 1360017032613<br/>
                        Atas nama Amazink Karya Indonesia <br/>
                    </div>
                </div>
                <!-- End Features Item -->

                <hr/>
                <div class="widget">

                    <h5 class="widget-title font-alt">
                        <a href="<?= base_url()?>cara_belanja.html">
                            <i class="fa fa-chevron-circle-right"></i> cara belanja
                        </a>
                    </h5>

                </div>
                <!-- End Widget -->
                <div class="widget">

                    <a href="https://www.bukalapak.com/amazinkstore">
                        <img class="img-responsive" src="<?= base_url()?>assets/images/logo-bukalapak.png">
                    </a>
                    <a href="https://www.tokopedia.com/amazink">
                        <img class="img-responsive" src="<?= base_url()?>assets/images/LOGO-TOKOPEDIA.png">
                    </a>

                </div>


            </div>
            <!-- End Features -->

        </div>
        <!-- End Product Content -->



    </div>
</section>
<!-- End Section -->

<!-- Related Products -->
<section class="page-section pt-0">
    <div class="container relative">

        <h2 class="section-title font-alt mb-70 mb-sm-40">
            Related Products
        </h2>

        <!-- Products Grid -->
        <div class="row multi-columns-row">
            <?php
            foreach ($feature as $ftr) {
                ?>
                <!-- Shop Item -->
                <div class="col-md-3 col-lg-3 mb-60 mb-xs-40">

                    <div class="post-prev-img">

                        <a href="<?= base_url() ?>toko/produk/<?= $ftr->id ?>/<?php echo url_title($ftr->product_name) ?>.html">
                            <img src="<?= base_url() ?>assets/product_image/<?= $ftr->product_image ?>" alt="" />
                        </a>
                        <?php
                        $diskon = $ftr->discount;
                        if ($diskon != 0) {
                            ?>
                            <div class="intro-label">
                                <span class="label label-danger bg-red">Diskon <?= $diskon ?>%</span>
                            </div>
                            <?php
                        }
                        ?>

                    </div>

                    <div class="post-prev-title font-alt align-center">
                        <a href="<?= base_url() ?>toko/produk/<?= $ftr->id ?>/<?php echo url_title($ftr->product_name) ?>.html">
                            <?= $ftr->product_name ?>
                        </a>
                    </div>

                    <div class="post-prev-text align-center">
                        <?php
                        $diskon = $ftr->discount;
                        $old_price = $ftr->price;
                        if ($diskon > 0) {
                            $new_price = $old_price - ($diskon / 100 * $old_price);
                            ?>
                            <del><?= $old_price ?></del>
                            &nbsp;
                            <strong><?= $new_price ?></strong>
                            <?php
                        } else {
                            ?>
                            <strong>Rp. <?= number_format($old_price) ?></strong>
                            <?php
                        }
                        ?>

                    </div>


                </div>
                <!-- End Shop Item -->
                <?php
            }
            ?>


        </div>
        <!-- End Products Grid -->

    </div>
</section>
<!-- End Related Products -->